/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.es.input.db;

import com.frameworkset.common.poolman.ConfigSQLExecutor;
import java.util.concurrent.CountDownLatch;
import org.frameworkset.elasticsearch.entity.MetaMap;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.output.AsynDBOutPutDataTran;
import org.frameworkset.tran.db.output.DBOutPutContext;
import org.frameworkset.tran.es.input.ESInputPlugin;
import org.frameworkset.tran.es.input.db.ESDirectExporterScrollHandler;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.util.TranUtil;

public class ES2DBDataTranPlugin
extends ESInputPlugin
implements DataTranPlugin {
    protected DBOutPutContext dbOutPutContext;

    public ES2DBDataTranPlugin(ImportContext importContext, ImportContext targetImportContext) {
        super(importContext, targetImportContext);
        this.dbOutPutContext = (DBOutPutContext)((Object)targetImportContext);
    }

    @Override
    public void beforeInit() {
        super.beforeInit();
        DBConfig targetDBConfig = this.dbOutPutContext.getTargetDBConfig(null);
        if (targetDBConfig != null) {
            this.initDS(targetDBConfig);
        }
        if (this.importContext.getDbConfig() != null) {
            this.initDS(this.importContext.getDbConfig());
        }
        this.initOtherDSes(this.importContext.getConfigs());
    }

    @Override
    public void afterInit() {
        String targetDBName = this.dbOutPutContext.getTargetDBName(null);
        if (targetDBName == null) {
            targetDBName = this.importContext.getTargetDBName();
        }
        TranUtil.initTargetSQLInfo(this.dbOutPutContext, targetDBName);
    }

    @Override
    protected BaseDataTran createBaseDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, CountDownLatch countDownLatch, Status currentStatus) {
        AsynDBOutPutDataTran asynDBOutPutDataTran = new AsynDBOutPutDataTran(taskContext, jdbcResultSet, this.importContext, this.targetImportContext, countDownLatch, currentStatus);
        asynDBOutPutDataTran.init();
        return asynDBOutPutDataTran;
    }

    @Override
    public void doImportData(TaskContext taskContext) throws ESDataImportException {
        if (this.dbOutPutContext.getBatchHandler() != null) {
            this.doBatchHandler(taskContext);
        } else {
            super.doImportData(taskContext);
        }
    }

    @Override
    protected void doBatchHandler(TaskContext taskContext) {
        ConfigSQLExecutor executor = null;
        if (taskContext.getSqlFilepath() != null) {
            executor = new ConfigSQLExecutor(taskContext.getSqlFilepath());
        } else if (this.dbOutPutContext.getSqlFilepath() != null) {
            executor = new ConfigSQLExecutor(this.dbOutPutContext.getSqlFilepath());
        }
        ESDirectExporterScrollHandler<MetaMap> esDirectExporterScrollHandler = new ESDirectExporterScrollHandler<MetaMap>(taskContext, this.importContext, this.targetImportContext, executor);
        try {
            if (!this.isIncreamentImport()) {
                this.commonImportData(taskContext, esDirectExporterScrollHandler);
            } else {
                this.increamentImportData(taskContext, esDirectExporterScrollHandler);
            }
        }
        catch (ESDataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }
}

