/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.es.input;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.MetaMap;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.BaseDataTranPlugin;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.es.BaseESExporterScrollHandler;
import org.frameworkset.tran.es.ES2TranResultSet;
import org.frameworkset.tran.es.input.ESExporterScrollHandler;
import org.frameworkset.tran.es.input.ESInputContext;
import org.frameworkset.tran.es.input.db.ESDirectExporterScrollHandler;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;

public abstract class ESInputPlugin
extends BaseDataTranPlugin
implements DataTranPlugin {
    protected ESInputContext esInputContext;

    @Override
    public void init(ImportContext importContext, ImportContext targetImportContext) {
        super.init(importContext, targetImportContext);
        this.esInputContext = (ESInputContext)((Object)importContext);
    }

    public ESInputPlugin(ImportContext importContext, ImportContext targetImportContext) {
        super(importContext, targetImportContext);
    }

    @Override
    public void beforeInit() {
        this.initES(this.importContext.getApplicationPropertiesFile());
    }

    @Override
    public void afterInit() {
    }

    @Override
    public void initStatusTableId() {
        if (this.isIncreamentImport() && this.esInputContext.getDslFile() != null && !this.esInputContext.getDslFile().equals("")) {
            try {
                ClientInterface clientInterface = ElasticSearchHelper.getConfigRestClientUtil((String)this.importContext.getSourceElasticsearch(), (String)this.esInputContext.getDslFile());
                ESInfo esInfo = clientInterface.getESInfo(this.esInputContext.getDslName());
                this.importContext.setStatusTableId(esInfo.getTemplate().hashCode());
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
        }
    }

    protected void commonImportData(TaskContext taskContext, BaseESExporterScrollHandler<MetaMap> esExporterScrollHandler) throws Exception {
        Map<String, Integer> params = this.esInputContext.getParams() != null ? this.esInputContext.getParams() : new HashMap();
        params.put("size", this.importContext.getFetchSize());
        if (this.esInputContext.isSliceQuery()) {
            params.put("sliceMax", this.esInputContext.getSliceSize());
        }
        Date date = new Date();
        this.exportESData(taskContext, esExporterScrollHandler, params, date, date);
    }

    protected String getQueryUrl(TaskContext taskContext, Date lastStartValue, Date lastEndValue) {
        if (this.esInputContext.getQueryUrl() != null) {
            return this.esInputContext.getQueryUrl();
        }
        if (this.esInputContext.getQueryUrlFunction() != null) {
            return this.esInputContext.getQueryUrlFunction().queryUrl(taskContext, lastStartValue, lastEndValue);
        }
        throw new DataImportException("query url or query url function not setted.");
    }

    protected void exportESData(TaskContext taskContext, BaseESExporterScrollHandler<MetaMap> esExporterScrollHandler, Map params, Date lastStartValue, Date lastEndValue) {
        ClientInterface clientUtil = ElasticSearchHelper.getConfigRestClientUtil((String)this.importContext.getSourceElasticsearch(), (String)this.esInputContext.getDslFile());
        ESDatas response = null;
        response = !this.esInputContext.isSliceQuery() ? (this.importContext.isParallel() && esExporterScrollHandler instanceof ESDirectExporterScrollHandler ? clientUtil.scrollParallel(this.getQueryUrl(taskContext, lastStartValue, lastEndValue), this.esInputContext.getDslName(), this.esInputContext.getScrollLiveTime(), params, MetaMap.class, esExporterScrollHandler) : clientUtil.scroll(this.getQueryUrl(taskContext, lastStartValue, lastEndValue), this.esInputContext.getDslName(), this.esInputContext.getScrollLiveTime(), params, MetaMap.class, esExporterScrollHandler)) : clientUtil.scrollSliceParallel(this.getQueryUrl(taskContext, lastStartValue, lastEndValue), this.esInputContext.getDslName(), params, this.esInputContext.getScrollLiveTime(), MetaMap.class, esExporterScrollHandler);
        if (this.logger.isInfoEnabled()) {
            if (response != null) {
                this.logger.info("Export compoleted and export total {} records.", (Object)response.getTotalSize());
            } else {
                this.logger.info("Export compoleted and export no records or failed.");
            }
        }
    }

    @Override
    protected Object formatLastDateValue(Date date) {
        String lastValueDateformat = this.importContext.getLastValueDateformat();
        if (lastValueDateformat != null && !lastValueDateformat.equals("")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(lastValueDateformat);
            return simpleDateFormat.format(date);
        }
        return date;
    }

    protected void increamentImportData(TaskContext taskContext, BaseESExporterScrollHandler<MetaMap> esExporterScrollHandler) throws Exception {
        Object[] lastValues;
        Object lastValue;
        Map<String, Integer> params = this.esInputContext.getParams() != null ? this.esInputContext.getParams() : new HashMap();
        params.put("size", this.importContext.getFetchSize());
        if (this.esInputContext.isSliceQuery()) {
            params.put("sliceMax", this.esInputContext.getSliceSize());
        }
        if ((lastValue = (lastValues = this.putLastParamValue(params))[0]) instanceof Date) {
            Date lastEndValue = null;
            lastEndValue = this.importContext.increamentEndOffset() != null ? (Date)lastValues[1] : new Date();
            this.exportESData(taskContext, esExporterScrollHandler, params, (Date)lastValue, lastEndValue);
        } else {
            Date date = new Date();
            this.exportESData(taskContext, esExporterScrollHandler, params, date, date);
        }
    }

    protected abstract BaseDataTran createBaseDataTran(TaskContext var1, TranResultSet var2, CountDownLatch var3, Status var4);

    protected void doBatchHandler(TaskContext taskContext) {
    }

    @Override
    public void doImportData(TaskContext taskContext) throws ESDataImportException {
        ES2TranResultSet jdbcResultSet = new ES2TranResultSet(this.importContext);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        final BaseDataTran es2DBDataTran = this.createBaseDataTran(taskContext, jdbcResultSet, countDownLatch, this.currentStatus);
        ESExporterScrollHandler<MetaMap> esExporterScrollHandler = new ESExporterScrollHandler<MetaMap>(this.importContext, this.targetImportContext, es2DBDataTran);
        try {
            Thread tranThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    es2DBDataTran.tran();
                }
            }, "Elasticsearch-DB-Tran");
            tranThread.start();
            if (!this.isIncreamentImport()) {
                this.commonImportData(taskContext, esExporterScrollHandler);
            } else {
                this.increamentImportData(taskContext, esExporterScrollHandler);
            }
        }
        catch (ESDataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
        finally {
            block13: {
                jdbcResultSet.reachEend();
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    if (!this.logger.isErrorEnabled()) break block13;
                    this.logger.error("", (Throwable)e);
                }
            }
        }
    }
}

