/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.db.output;

import com.frameworkset.common.poolman.Param;
import com.frameworkset.util.VariableHandler;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.persitent.util.PersistentSQLVariable;
import org.frameworkset.tran.BaseCommonRecordDataTran;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.DBRecord;
import org.frameworkset.tran.db.output.Base2DBTaskCommandImpl;
import org.frameworkset.tran.db.output.DBOutPutContext;
import org.frameworkset.tran.db.output.TranSQLInfo;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.metrics.ParallImportCount;
import org.frameworkset.tran.metrics.SerialImportCount;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.TaskCall;
import org.slf4j.Logger;

public class DBOutPutDataTran
extends BaseCommonRecordDataTran {
    protected DBOutPutContext es2DBContext;
    private String taskInfo;

    @Override
    public void logTaskStart(Logger logger) {
        logger.info(this.taskInfo + " start.");
    }

    @Override
    public void init() {
        super.init();
        this.es2DBContext = this.targetImportContext == null ? (DBOutPutContext)((Object)this.importContext) : (DBOutPutContext)((Object)this.targetImportContext);
        StringBuilder builder = new StringBuilder();
        DBConfig dbConfig = this.es2DBContext.getTargetDBConfig(this.taskContext);
        if (dbConfig == null) {
            dbConfig = this.importContext.getDbConfig();
        }
        if (dbConfig != null) {
            builder.append("Import data to db[").append(dbConfig.getDbUrl()).append("] dbuser[").append(dbConfig.getDbUser()).append("]");
        } else {
            String targetDBName = this.es2DBContext.getTargetDBName(this.taskContext);
            if (targetDBName == null) {
                targetDBName = this.importContext.getTargetDBName();
            }
            builder.append("Import data to db[").append(targetDBName).append("]");
        }
        if (this.es2DBContext.getTargetSqlInfo(this.taskContext) != null) {
            builder.append(" insert sql[").append(this.es2DBContext.getTargetSqlInfo(this.taskContext).getOriginSQL()).append("]");
        }
        if (this.es2DBContext.getTargetUpdateSqlInfo(this.taskContext) != null) {
            builder.append("\r\nupdate sql[").append(this.es2DBContext.getTargetUpdateSqlInfo(this.taskContext).getOriginSQL()).append("]");
        }
        if (this.es2DBContext.getTargetDeleteSqlInfo(this.taskContext) != null) {
            builder.append("\r\ndelete sql[").append(this.es2DBContext.getTargetDeleteSqlInfo(this.taskContext).getOriginSQL()).append("]");
        }
        this.taskInfo = builder.toString();
    }

    public DBOutPutDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, ImportContext targetImportContext, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, targetImportContext, currentStatus);
    }

    @Override
    public String serialExecute() {
        Object lastValue = null;
        Throwable exception = null;
        long start = System.currentTimeMillis();
        Status currentStatus = this.currentStatus;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        SerialImportCount importCount = new SerialImportCount();
        int taskNo = 0;
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        boolean reachEOFClosed = false;
        try {
            Object temp = null;
            ArrayList<DBRecord> records = new ArrayList<DBRecord>();
            while (true) {
                Boolean hasNext;
                if ((hasNext = this.jdbcResultSet.next()) == null) {
                    if (records.size() > 0) {
                        Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(importCount, this.importContext, this.targetImportContext, records, ++taskNo, importCount.getJobNo(), this.taskInfo, true, lastValue, currentStatus, reachEOFClosed, this.taskContext);
                        TaskCall.call(taskCommand);
                        records.clear();
                        if (this.isPrintTaskLog()) {
                            long end = System.currentTimeMillis();
                            this.logger.info("Serial import Force flush records Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records.");
                        }
                    }
                    if (!this.isPrintTaskLog()) continue;
                    long end = System.currentTimeMillis();
                    this.logger.info("Serial import Force flush datas Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                try {
                    lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                    Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, null);
                    if (!reachEOFClosed) {
                        reachEOFClosed = context.reachEOFClosed();
                    }
                    if (context.removed()) {
                        if (!reachEOFClosed) {
                            ((ImportCount)importCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                        continue;
                    }
                    context.refactorData();
                    context.afterRefactor();
                    if (context.isDrop()) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    DBRecord record = this.buildDBRecord(context);
                    records.add(record);
                    ++totalCount;
                }
                catch (Exception e) {
                    throw new ElasticSearchException((Throwable)e);
                }
            }
            if (records.size() > 0) {
                Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(importCount, this.importContext, this.targetImportContext, records, ++taskNo, importCount.getJobNo(), this.taskInfo, true, lastValue, currentStatus, reachEOFClosed, this.taskContext);
                TaskCall.call(taskCommand);
            }
            if (this.isPrintTaskLog()) {
                long end = System.currentTimeMillis();
                this.logger.info("Serial import All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ((ImportCount)importCount).getIgnoreTotalCount() + " records.");
            }
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition(exception, this.importContext)) {
                if (!this.importContext.getDataTranPlugin().isMultiTran()) {
                    this.stop();
                } else {
                    this.stopTranOnly();
                }
            }
            if (this.importContext.isCurrentStoped()) {
                this.stopTranOnly();
            }
            importCount.setJobEndTime(new Date());
        }
        return null;
    }

    protected DBRecord buildDBRecord(Context context) {
        DBRecord dbRecord = new DBRecord();
        List<VariableHandler.Variable> vars = null;
        Object temp = null;
        Param param = null;
        TranSQLInfo insertSqlinfo = this.es2DBContext.getTargetSqlInfo(context.getTaskContext());
        TranSQLInfo updateSqlinfo = this.es2DBContext.getTargetUpdateSqlInfo(context.getTaskContext());
        TranSQLInfo deleteSqlinfo = this.es2DBContext.getTargetDeleteSqlInfo(context.getTaskContext());
        if (context.isInsert()) {
            dbRecord.setAction(0);
            vars = insertSqlinfo.getVars();
        } else if (context.isUpdate()) {
            dbRecord.setAction(1);
            vars = updateSqlinfo.getVars();
        } else {
            dbRecord.setAction(2);
            vars = deleteSqlinfo.getVars();
        }
        super.buildRecord(dbRecord, context);
        String varName = null;
        ArrayList<Param> record = new ArrayList<Param>();
        for (int i = 0; i < vars.size(); ++i) {
            PersistentSQLVariable var = (PersistentSQLVariable)vars.get(i);
            varName = var.getVariableName();
            temp = dbRecord.getData(varName);
            if (temp == null && this.logger.isDebugEnabled()) {
                this.logger.debug("\u672a\u6307\u5b9a\u7ed1\u5b9a\u53d8\u91cf\u7684\u503c\uff1a{}", (Object)varName);
            }
            param = new Param();
            param.setVariable((VariableHandler.Variable)var);
            param.setIndex(var.getPosition() + 1);
            param.setData(temp);
            param.setName(varName);
            param.setMethod(var.getMethod());
            record.add(param);
        }
        dbRecord.setParams(record);
        return dbRecord;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String parallelBatchExecute() {
        boolean reachEOFClosed;
        TranErrorWrapper tranErrorWrapper;
        Object lastValue;
        Throwable exception;
        ParallImportCount totalCount;
        ArrayList<Future> tasks;
        ExecutorService service;
        block19: {
            int count = 0;
            service = this.importContext.buildThreadPool();
            tasks = new ArrayList<Future>();
            int taskNo = 0;
            totalCount = new ParallImportCount();
            exception = null;
            Status currentStatus = this.currentStatus;
            Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
            lastValue = null;
            tranErrorWrapper = new TranErrorWrapper(this.importContext);
            int batchsize = this.importContext.getStoreBatchSize();
            reachEOFClosed = false;
            try {
                block18: {
                    TranSQLInfo sqlinfo = this.es2DBContext.getTargetSqlInfo(this.taskContext);
                    Object temp = null;
                    ArrayList<DBRecord> records = new ArrayList<DBRecord>();
                    while (true) {
                        Boolean hasNext;
                        if (!tranErrorWrapper.assertCondition()) {
                            tranErrorWrapper.throwError();
                        }
                        if ((hasNext = this.jdbcResultSet.next()) == null) {
                            if (count <= 0) continue;
                            count = 0;
                            Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(totalCount, this.importContext, this.targetImportContext, records, ++taskNo, totalCount.getJobNo(), this.taskInfo, false, lastValue, currentStatus, reachEOFClosed, this.taskContext);
                            records = new ArrayList();
                            tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                            continue;
                        }
                        if (!hasNext.booleanValue()) {
                            if (count > 0) {
                                break;
                            }
                            break block18;
                        }
                        lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                        Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, null);
                        if (!reachEOFClosed) {
                            reachEOFClosed = context.reachEOFClosed();
                        }
                        if (context.removed()) {
                            if (!reachEOFClosed) {
                                ((ImportCount)totalCount).increamentIgnoreTotalCount();
                                continue;
                            }
                            this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                            continue;
                        }
                        context.refactorData();
                        context.afterRefactor();
                        if (context.isDrop()) {
                            ((ImportCount)totalCount).increamentIgnoreTotalCount();
                            continue;
                        }
                        DBRecord record = this.buildDBRecord(context);
                        records.add(record);
                        if (++count < batchsize) continue;
                        count = 0;
                        Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(totalCount, this.importContext, this.targetImportContext, records, ++taskNo, totalCount.getJobNo(), this.taskInfo, false, lastValue, currentStatus, reachEOFClosed, this.taskContext);
                        records = new ArrayList();
                        tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                    }
                    if (!tranErrorWrapper.assertCondition()) {
                        tranErrorWrapper.throwError();
                    }
                    Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(totalCount, this.importContext, this.targetImportContext, records, ++taskNo, totalCount.getJobNo(), this.taskInfo, false, lastValue, currentStatus, reachEOFClosed, this.taskContext);
                    tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                    if (this.isPrintTaskLog()) {
                        this.logger.info("Pararrel batchsubmit tasks:" + taskNo);
                    }
                    break block19;
                }
                if (this.isPrintTaskLog()) {
                    this.logger.info("Pararrel batchsubmit tasks:" + taskNo);
                }
            }
            catch (SQLException e) {
                try {
                    exception = e;
                    throw new ElasticSearchException((Throwable)e);
                    catch (ElasticSearchException e2) {
                        exception = e2;
                        throw e2;
                    }
                    catch (Exception e3) {
                        exception = e3;
                        throw new ElasticSearchException((Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper, null, reachEOFClosed);
                    totalCount.setJobEndTime(new Date());
                    throw throwable;
                }
            }
        }
        this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper, null, reachEOFClosed);
        totalCount.setJobEndTime(new Date());
        return null;
    }

    @Override
    public String batchExecute() {
        int count = 0;
        String ret = null;
        int taskNo = 0;
        Throwable exception = null;
        Status currentStatus = this.currentStatus;
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        Object lastValue = null;
        TranErrorWrapper tranErrorWrapper = new TranErrorWrapper(this.importContext);
        long start = System.currentTimeMillis();
        long istart = 0L;
        long end = 0L;
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        SerialImportCount importCount = new SerialImportCount();
        int batchsize = this.importContext.getStoreBatchSize();
        boolean reachEOFClosed = false;
        try {
            istart = start;
            ArrayList<DBRecord> records = new ArrayList<DBRecord>();
            while (true) {
                Boolean hasNext;
                if (!tranErrorWrapper.assertCondition()) {
                    this.jdbcResultSet.stop();
                    tranErrorWrapper.throwError();
                }
                if ((hasNext = this.jdbcResultSet.next()) == null) {
                    if (count <= 0) continue;
                    Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(importCount, this.importContext, this.targetImportContext, records, ++taskNo, importCount.getJobNo(), this.taskInfo, false, lastValue, currentStatus, reachEOFClosed, this.taskContext);
                    int temp = count;
                    count = 0;
                    records = new ArrayList();
                    ret = TaskCall.call(taskCommand);
                    if (this.isPrintTaskLog()) {
                        end = System.currentTimeMillis();
                        this.logger.info("Batch import Force flush datas Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + temp + " records.");
                        istart = end;
                    }
                    totalCount += (long)temp;
                    continue;
                }
                if (!hasNext.booleanValue()) break;
                lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                Context context = this.importContext.buildContext(this.taskContext, this.jdbcResultSet, null);
                if (!reachEOFClosed) {
                    reachEOFClosed = context.reachEOFClosed();
                }
                if (context.removed()) {
                    if (!reachEOFClosed) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                    continue;
                }
                context.refactorData();
                context.afterRefactor();
                if (context.isDrop()) {
                    ((ImportCount)importCount).increamentIgnoreTotalCount();
                    continue;
                }
                DBRecord record = this.buildDBRecord(context);
                records.add(record);
                if (++count < batchsize) continue;
                Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(importCount, this.importContext, this.targetImportContext, records, ++taskNo, importCount.getJobNo(), this.taskInfo, false, lastValue, currentStatus, reachEOFClosed, this.taskContext);
                int temp = count;
                count = 0;
                records = new ArrayList();
                ret = TaskCall.call(taskCommand);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    this.logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + temp + " records.");
                    istart = end;
                }
                totalCount += (long)temp;
            }
            if (count > 0) {
                if (!tranErrorWrapper.assertCondition()) {
                    tranErrorWrapper.throwError();
                }
                Base2DBTaskCommandImpl taskCommand = new Base2DBTaskCommandImpl(importCount, this.importContext, this.targetImportContext, records, ++taskNo, importCount.getJobNo(), this.taskInfo, false, lastValue, currentStatus, reachEOFClosed, this.taskContext);
                ret = TaskCall.call(taskCommand);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    this.logger.info("Batch import Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + count + " records.");
                }
                totalCount += (long)count;
            }
            if (this.isPrintTaskLog()) {
                end = System.currentTimeMillis();
                this.logger.info("Batch import Execute Tasks:" + taskNo + ",All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!tranErrorWrapper.assertCondition((Exception)exception)) {
                if (!this.importContext.getDataTranPlugin().isMultiTran()) {
                    this.stop();
                } else {
                    this.stopTranOnly();
                }
            }
            importCount.setJobEndTime(new Date());
        }
        return ret;
    }
}

