/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.db.output;

import com.frameworkset.common.poolman.DBUtil;
import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.Param;
import com.frameworkset.common.poolman.StatementInfo;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.persitent.type.BaseTypeMethod;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.DBRecord;
import org.frameworkset.tran.db.output.DBOutPutContext;
import org.frameworkset.tran.db.output.TranSQLInfo;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.BaseTaskCommand;
import org.frameworkset.tran.task.TaskFailedException;

public class Base2DBTaskCommandImpl
extends BaseTaskCommand<List<DBRecord>, String> {
    private DBOutPutContext es2DBContext;
    private String taskInfo;
    private boolean needBatch;
    private List<DBRecord> datas;
    private int tryCount;

    public Base2DBTaskCommandImpl(ImportCount importCount, ImportContext importContext, ImportContext targetImportContext, List<DBRecord> datas, int taskNo, String jobNo, String taskInfo, boolean needBatch, Object lastValue, Status currentStatus, boolean reachEOFClosed, TaskContext taskContext) {
        super(importCount, importContext, targetImportContext, datas.size(), taskNo, jobNo, lastValue, currentStatus, reachEOFClosed, taskContext);
        this.needBatch = needBatch;
        this.importContext = importContext;
        this.datas = datas;
        this.es2DBContext = (DBOutPutContext)((Object)targetImportContext);
        this.taskInfo = taskInfo;
        if (this.es2DBContext.optimize()) {
            this.sortData();
        }
    }

    private void sortData() {
        ArrayList<DBRecord> _idatas = new ArrayList<DBRecord>();
        ArrayList<DBRecord> _udatas = new ArrayList<DBRecord>();
        ArrayList<DBRecord> _ddatas = new ArrayList<DBRecord>();
        for (int i = 0; this.datas != null && i < this.datas.size(); ++i) {
            DBRecord dbRecord = this.datas.get(i);
            if (dbRecord.isInsert()) {
                _idatas.add(dbRecord);
                continue;
            }
            if (dbRecord.isUpate()) {
                _udatas.add(dbRecord);
                continue;
            }
            _ddatas.add(dbRecord);
        }
        if (_udatas.size() == 0 && _ddatas.size() == 0 || _idatas.size() == 0 && _ddatas.size() == 0 || _idatas.size() == 0 && _udatas.size() == 0) {
            return;
        }
        this.datas.clear();
        if (_idatas.size() > 0) {
            this.datas.addAll(_idatas);
        }
        if (_udatas.size() > 0) {
            this.datas.addAll(_udatas);
        }
        if (_ddatas.size() > 0) {
            this.datas.addAll(_ddatas);
        }
    }

    @Override
    public List<DBRecord> getDatas() {
        return this.datas;
    }

    @Override
    public void setDatas(List<DBRecord> datas) {
        this.datas = datas;
    }

    private void debugDB(String name) {
        DBUtil.debugStatus((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute() {
        String data;
        block66: {
            data = null;
            if (this.importContext.getMaxRetry() > 0 && this.tryCount >= this.importContext.getMaxRetry()) {
                throw new TaskFailedException("task execute failed:reached max retry times " + this.importContext.getMaxRetry());
            }
            ++this.tryCount;
            StatementInfo stmtInfo = null;
            Statement statement = null;
            TranSQLInfo insertSqlinfo = this.es2DBContext.getTargetSqlInfo(this.taskContext);
            TranSQLInfo updateSqlinfo = this.es2DBContext.getTargetUpdateSqlInfo(this.taskContext);
            TranSQLInfo deleteSqlinfo = this.es2DBContext.getTargetDeleteSqlInfo(this.taskContext);
            Connection con_ = null;
            int batchsize = this.importContext.getStoreBatchSize();
            try {
                String dbname = this.es2DBContext.getTargetDBName(this.taskContext);
                if (dbname == null) {
                    dbname = this.importContext.getTargetDBName();
                }
                con_ = DBUtil.getConection((String)dbname);
                stmtInfo = new StatementInfo(dbname, null, false, con_, false);
                stmtInfo.init();
                String oldSql = null;
                String sql = null;
                if (batchsize <= 1 || !this.needBatch) {
                    for (DBRecord record : this.datas) {
                        sql = record.isInsert() ? insertSqlinfo.getSql() : (record.isUpate() ? updateSqlinfo.getSql() : deleteSqlinfo.getSql());
                        if (oldSql == null) {
                            oldSql = sql;
                            statement = stmtInfo.prepareStatement(sql);
                        } else if (!oldSql.equals(sql)) {
                            try {
                                statement.executeBatch();
                                this.finishTask();
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                try {
                                    statement.close();
                                }
                                catch (Exception exception) {}
                            }
                            oldSql = sql;
                            statement = stmtInfo.prepareStatement(sql);
                        }
                        if (this.es2DBContext.getStatementHandler() == null) {
                            BaseTypeMethod baseTypeMethod = null;
                            for (int i = 0; i < record.size(); ++i) {
                                Param param = record.get(i);
                                baseTypeMethod = param.getMethod();
                                if (baseTypeMethod == null) {
                                    stmtInfo.getDbadapter().setObject((PreparedStatement)statement, null, param.getIndex(), param.getData());
                                    continue;
                                }
                                baseTypeMethod.action(stmtInfo, param, (PreparedStatement)statement, null, (List)null);
                            }
                        } else {
                            this.es2DBContext.getStatementHandler().handler((PreparedStatement)statement, record);
                        }
                        try {
                            statement.addBatch();
                        }
                        catch (SQLException e) {
                            throw new NestedSQLException(record.toString(), (Throwable)e);
                        }
                    }
                    if (statement != null) {
                        statement.executeBatch();
                        this.finishTask();
                    }
                    break block66;
                }
                int point = batchsize - 1;
                int count = 0;
                for (DBRecord record : this.datas) {
                    sql = record.isInsert() ? insertSqlinfo.getSql() : (record.isUpate() ? updateSqlinfo.getSql() : deleteSqlinfo.getSql());
                    if (oldSql == null) {
                        oldSql = sql;
                        statement = stmtInfo.prepareStatement(sql);
                    } else if (!oldSql.equals(sql)) {
                        try {
                            if (count > 0) {
                                statement.executeBatch();
                                this.finishTask();
                            }
                        }
                        catch (Exception param) {
                        }
                        finally {
                            try {
                                statement.close();
                            }
                            catch (Exception param) {}
                        }
                        count = 0;
                        oldSql = sql;
                        statement = stmtInfo.prepareStatement(sql);
                    }
                    if (this.es2DBContext.getStatementHandler() == null) {
                        BaseTypeMethod baseTypeMethod = null;
                        for (int i = 0; i < record.size(); ++i) {
                            Param param = record.get(i);
                            baseTypeMethod = param.getMethod();
                            if (baseTypeMethod == null) {
                                stmtInfo.getDbadapter().setObject((PreparedStatement)statement, null, param.getIndex(), param.getData());
                                continue;
                            }
                            baseTypeMethod.action(stmtInfo, param, (PreparedStatement)statement, null, (List)null);
                        }
                    } else {
                        this.es2DBContext.getStatementHandler().handler((PreparedStatement)statement, record);
                    }
                    statement.addBatch();
                    if (count > 0 && count % point == 0) {
                        statement.executeBatch();
                        this.finishTask();
                        statement.clearBatch();
                        count = 0;
                        continue;
                    }
                    ++count;
                }
                if (count > 0) {
                    statement.executeBatch();
                    this.finishTask();
                }
            }
            catch (BatchUpdateException error) {
                if (stmtInfo != null) {
                    try {
                        stmtInfo.errorHandle((Exception)error);
                    }
                    catch (SQLException ex) {
                        throw new ElasticSearchException(this.taskInfo, (Throwable)error);
                    }
                }
                throw new ElasticSearchException(this.taskInfo, (Throwable)error);
            }
            catch (Exception e) {
                if (stmtInfo != null) {
                    try {
                        stmtInfo.errorHandle(e);
                    }
                    catch (SQLException ex) {
                        throw new ElasticSearchException(this.taskInfo, (Throwable)e);
                    }
                }
                throw new ElasticSearchException(this.taskInfo, (Throwable)e);
            }
            finally {
                if (stmtInfo != null) {
                    stmtInfo.dofinally();
                }
                if (con_ != null) {
                    try {
                        con_.close();
                    }
                    catch (Exception exception) {}
                }
                stmtInfo = null;
            }
        }
        return data;
    }

    @Override
    public int getTryCount() {
        return this.tryCount;
    }
}

