/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.db.input;

import com.frameworkset.common.poolman.ConfigSQLExecutor;
import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.ResultSetHandler;
import com.frameworkset.common.poolman.util.DBOptions;
import com.frameworkset.orm.transaction.TransactionManager;
import com.frameworkset.util.SimpleStringUtil;
import java.sql.SQLException;
import java.util.List;
import org.frameworkset.persitent.util.SQLInfo;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.BaseDataTranPlugin;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.DBContext;
import org.frameworkset.tran.db.input.DefaultResultSetHandler;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.TaskFailedException;
import org.frameworkset.util.tokenizer.TextGrammarParser;

public abstract class SQLBaseDataTranPlugin
extends BaseDataTranPlugin {
    protected org.frameworkset.tran.schedule.SQLInfo sqlInfo;
    protected ConfigSQLExecutor executor;
    protected DBContext dbContext;

    public SQLBaseDataTranPlugin(ImportContext importContext, ImportContext targetImportContext) {
        super(importContext, targetImportContext);
    }

    @Override
    public void init(ImportContext importContext, ImportContext targetImportContext) {
        super.init(importContext, targetImportContext);
        this.dbContext = (DBContext)((Object)importContext);
    }

    @Override
    public void beforeInit() {
        this.initDS(this.importContext.getDbConfig());
        this.initOtherDSes(this.importContext.getConfigs());
        this.initSourceSQLInfo();
    }

    @Override
    public void afterInit() {
        if (this.sqlInfo != null && this.sqlInfo.getParamSize() > 0 && !this.isIncreamentImport()) {
            throw new TaskFailedException("Parameter variables cannot be set in non-incremental import SQL statements\uff1a" + this.dbContext.getSql());
        }
    }

    @Override
    public void initStatusTableId() {
        if (this.isIncreamentImport() && this.dbContext.getSql() != null && !this.dbContext.getSql().equals("")) {
            this.importContext.setStatusTableId(this.dbContext.getSql().hashCode());
        }
    }

    public void initSourceSQLInfo() {
        if ((this.dbContext.getSql() == null || this.dbContext.getSql().equals("")) && this.dbContext.getSqlFilepath() != null && !this.dbContext.getSqlFilepath().equals("")) {
            try {
                ConfigSQLExecutor executor = new ConfigSQLExecutor(this.dbContext.getSqlFilepath());
                SQLInfo sqlInfo = executor.getSqlInfo(this.getSourceDBName(), this.dbContext.getSqlName());
                this.executor = executor;
                this.dbContext.setSql(sqlInfo.getSql());
            }
            catch (SQLException e) {
                throw new ESDataImportException(e);
            }
        }
        if (this.dbContext.getSql() != null && !this.dbContext.getSql().equals("")) {
            this.initSQLInfoParams();
        }
    }

    private void initSQLInfoParams() {
        String originSQL = this.dbContext.getSql();
        List tokens = TextGrammarParser.parser((String)originSQL, (String)"#[", (String)"]");
        org.frameworkset.tran.schedule.SQLInfo _sqlInfo = new org.frameworkset.tran.schedule.SQLInfo();
        int paramSize = 0;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            TextGrammarParser.GrammarToken token = (TextGrammarParser.GrammarToken)tokens.get(i);
            if (token.texttoken()) {
                builder.append(token.getText());
                continue;
            }
            builder.append("?");
            if (paramSize == 0) {
                _sqlInfo.setLastValueVarName(token.getText());
            }
            ++paramSize;
        }
        _sqlInfo.setParamSize(paramSize);
        _sqlInfo.setSql(builder.toString());
        this.sqlInfo = _sqlInfo;
    }

    public org.frameworkset.tran.schedule.SQLInfo getSqlInfo() {
        return this.sqlInfo;
    }

    @Override
    public String getLastValueVarName() {
        return this.sqlInfo != null ? this.sqlInfo.getLastValueVarName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonImportData(ResultSetHandler resultSetHandler) throws Exception {
        String sourceDBName = this.getSourceDBName();
        boolean isEnableDBTransaction = this.importContext.getDbConfig() != null ? this.importContext.getDbConfig().isEnableDBTransaction() : false;
        DBOptions dbOptions = this.getDBOptions();
        if (this.importContext.getDataRefactor() == null || !isEnableDBTransaction) {
            if (this.executor == null) {
                SQLExecutor.queryWithDBNameByNullRowHandler((DBOptions)dbOptions, (NullRowHandler)resultSetHandler, (String)sourceDBName, (String)this.dbContext.getSql(), (Object[])new Object[0]);
            } else {
                this.executor.queryWithDBNameByNullRowHandler(dbOptions, (NullRowHandler)resultSetHandler, sourceDBName, this.dbContext.getSqlName(), new Object[0]);
            }
        } else {
            TransactionManager transactionManager = new TransactionManager();
            try {
                transactionManager.begin(TransactionManager.RW_TRANSACTION);
                if (this.executor == null) {
                    SQLExecutor.queryWithDBNameByNullRowHandler((DBOptions)dbOptions, (NullRowHandler)resultSetHandler, (String)sourceDBName, (String)this.dbContext.getSql(), (Object[])new Object[0]);
                } else {
                    this.executor.queryWithDBNameByNullRowHandler(dbOptions, (NullRowHandler)resultSetHandler, sourceDBName, this.dbContext.getSqlName(), new Object[0]);
                }
                transactionManager.commit();
            }
            finally {
                transactionManager.releasenolog();
            }
        }
    }

    private String getSourceDBName() {
        DBConfig dbConfig = this.importContext.getDbConfig();
        String sourceDBName = this.importContext.getSourceDBName();
        if (sourceDBName == null && dbConfig != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbName())) {
            sourceDBName = dbConfig.getDbName();
        }
        if (sourceDBName == null) {
            throw new ESDataImportException("DbConfig is null,please set dbname use importBuilder.setDbName(dbname) or importBuilder.setSourceDBName(dbname) and  other database configs use importBuilder,dbname and other database configs can also been configed in appliction.properties file or other config file bboss supported.");
        }
        return sourceDBName;
    }

    private DBOptions getDBOptions() {
        DBOptions dbOptions = null;
        if (this.importContext.getJDBCFetchsize() != null && this.importContext.getJDBCFetchsize() != 0) {
            dbOptions = new DBOptions();
            dbOptions.setFetchSize(this.importContext.getJDBCFetchsize());
        }
        return dbOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increamentImportData(ResultSetHandler resultSetHandler) throws Exception {
        boolean isEnableDBTransaction;
        String sourceDBName = this.getSourceDBName();
        DBOptions dbOptions = this.getDBOptions();
        boolean bl = isEnableDBTransaction = this.importContext.getDbConfig() != null ? this.importContext.getDbConfig().isEnableDBTransaction() : false;
        if (this.importContext.getDataRefactor() == null || !isEnableDBTransaction) {
            if (this.executor == null) {
                SQLExecutor.queryBeanWithDBNameByNullRowHandler((DBOptions)dbOptions, (NullRowHandler)resultSetHandler, (String)sourceDBName, (String)this.dbContext.getSql(), (Object)this.getParamValue());
            } else {
                this.executor.queryBeanWithDBNameByNullRowHandler(dbOptions, (NullRowHandler)resultSetHandler, sourceDBName, this.dbContext.getSqlName(), (Object)this.getParamValue());
            }
        } else {
            TransactionManager transactionManager = new TransactionManager();
            try {
                transactionManager.begin(TransactionManager.RW_TRANSACTION);
                if (this.executor == null) {
                    SQLExecutor.queryBeanWithDBNameByNullRowHandler((DBOptions)dbOptions, (NullRowHandler)resultSetHandler, (String)sourceDBName, (String)this.dbContext.getSql(), (Object)this.getParamValue());
                } else {
                    this.executor.queryBeanWithDBNameByNullRowHandler(dbOptions, (NullRowHandler)resultSetHandler, sourceDBName, this.dbContext.getSqlName(), (Object)this.getParamValue());
                }
            }
            finally {
                transactionManager.releasenolog();
            }
        }
    }

    public abstract BaseDataTran createBaseDataTran(TaskContext var1, TranResultSet var2, Status var3);

    @Override
    public void doImportData(TaskContext taskContext) throws ESDataImportException {
        DefaultResultSetHandler resultSetHandler = new DefaultResultSetHandler(taskContext, this.importContext, this.targetImportContext, this);
        try {
            if (this.sqlInfo.getParamSize() == 0) {
                this.commonImportData(resultSetHandler);
            } else if (!this.isIncreamentImport()) {
                this.setForceStop();
            } else {
                this.increamentImportData(resultSetHandler);
            }
        }
        catch (ESDataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }
}

