/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.db;

import com.frameworkset.orm.adapter.DB;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.db.JDBCTranMetaData;
import org.frameworkset.tran.record.BaseRecord;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.schedule.timer.TimeUtil;

public class JDBCResultRecord
extends BaseRecord {
    protected ResultSet resultSet;
    protected JDBCTranMetaData metaData;
    protected DB dbadapter;

    public JDBCResultRecord(TaskContext taskContext, ResultSet resultSet, JDBCTranMetaData metaData, DB dbadapter) {
        super(taskContext);
        this.resultSet = resultSet;
        this.metaData = metaData;
        this.dbadapter = dbadapter;
    }

    private boolean isOracleTimestamp(int sqlType) {
        return this.dbadapter.isOracleTimestamp(sqlType);
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws ESDataImportException {
        try {
            if (!this.isOracleTimestamp(sqlType)) {
                Object value = this.resultSet.getObject(i + 1);
                value = TimeUtil.convertLocalDate(value);
                return value;
            }
            return this.resultSet.getTimestamp(i + 1);
        }
        catch (Exception ex) {
            throw new ESDataImportException("getValue(  " + i + ", " + colName + "," + sqlType + ")", ex);
        }
    }

    @Override
    public Date getDateTimeValue(String colName) throws ESDataImportException {
        if (colName == null) {
            return null;
        }
        try {
            Timestamp value = this.resultSet.getTimestamp(colName);
            return value;
        }
        catch (Exception e) {
            try {
                java.sql.Date value = this.resultSet.getDate(colName);
                return value;
            }
            catch (Exception ex) {
                throw new ESDataImportException("getValue(" + colName + ")", ex);
            }
        }
    }

    @Override
    public Date getDateTimeValue(String colName, String dateformat) throws ESDataImportException {
        if (colName == null) {
            return null;
        }
        try {
            Timestamp value = this.resultSet.getTimestamp(colName);
            return value;
        }
        catch (Exception e) {
            try {
                java.sql.Date value = this.resultSet.getDate(colName);
                return value;
            }
            catch (Exception ex) {
                throw new ESDataImportException("getValue(" + colName + ")", ex);
            }
        }
    }

    @Override
    public Object getValue(String colName, int sqlType) throws ESDataImportException {
        if (colName == null) {
            return null;
        }
        try {
            if (!this.isOracleTimestamp(sqlType)) {
                Object value = this.resultSet.getObject(colName);
                value = TimeUtil.convertLocalDate(value);
                return value;
            }
            return this.resultSet.getTimestamp(colName);
        }
        catch (Exception ex) {
            throw new ESDataImportException("getValue(  " + colName + "," + sqlType + ")", ex);
        }
    }

    @Override
    public Object getValue(String colName) {
        if (colName == null) {
            return null;
        }
        try {
            Object value = this.resultSet.getObject(colName);
            value = TimeUtil.convertLocalDate(value);
            return value;
        }
        catch (Exception ex) {
            throw new ESDataImportException("getValue(" + colName + ")", ex);
        }
    }

    @Override
    public Object getKeys() {
        return this.metaData.getPoolManResultSetMetaData().get_columnLabel();
    }

    @Override
    public Object getData() {
        return this.resultSet;
    }

    @Override
    public Object getMetaValue(String metaName) {
        return this.getValue(metaName);
    }

    @Override
    public long getOffset() {
        return 0L;
    }

    @Override
    public boolean removed() {
        return false;
    }

    @Override
    public boolean reachEOFClosed() {
        return false;
    }
}

