/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.db;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.util.SimpleStringUtil;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.context.BaseImportContext;
import org.frameworkset.tran.db.DBImportConfig;
import org.frameworkset.tran.db.StatementHandler;
import org.frameworkset.tran.db.output.DBOutPutContext;
import org.frameworkset.tran.db.output.TranSQLInfo;
import org.frameworkset.tran.schedule.TaskContext;

public class DBImportContext
extends BaseImportContext
implements DBOutPutContext {
    protected DBImportConfig dbImportConfig;
    private TranSQLInfo targetSqlInfo;
    private TranSQLInfo targetUpdateSqlInfo;
    private TranSQLInfo targetDeleteSqlInfo;

    @Override
    public String getTargetDBName(TaskContext taskContext) {
        DBConfig dbConfig = this.getTargetDBConfig(taskContext);
        if (dbConfig != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbName())) {
            return dbConfig.getDbName();
        }
        String dbName = this.dbImportConfig.getTargetDbname();
        if (dbName == null) {
            dbName = this.dbImportConfig.getSourceDbname();
        }
        return dbName;
    }

    @Override
    public DBConfig getTargetDBConfig(TaskContext taskContext) {
        if (taskContext != null && taskContext.getTargetDBConfig() != null) {
            return taskContext.getTargetDBConfig();
        }
        return this.dbImportConfig.getTargetDBConfig();
    }

    @Override
    public boolean optimize() {
        return this.dbImportConfig.optimize();
    }

    @Override
    public StatementHandler getStatementHandler() {
        return this.dbImportConfig.getStatementHandler();
    }

    @Override
    public BatchHandler getBatchHandler() {
        return this.dbImportConfig.getBatchHandler();
    }

    @Override
    public void init() {
        this.dbImportConfig = (DBImportConfig)this.baseImportConfig;
    }

    public DBImportContext() {
        super(new DBImportConfig());
    }

    public DBImportContext(BaseImportConfig baseImportConfig) {
        super(baseImportConfig);
    }

    @Override
    public String getSql() {
        return this.dbImportConfig.getSql();
    }

    @Override
    public String getSqlFilepath() {
        return this.dbImportConfig.getSqlFilepath();
    }

    @Override
    public String getSqlName() {
        return this.dbImportConfig.getSqlName();
    }

    @Override
    public void setSql(String sql) {
        this.dbImportConfig.setSql(sql);
    }

    @Override
    public String getInsertSqlName() {
        return this.dbImportConfig.getInsertSqlName();
    }

    @Override
    public String getInsertSql() {
        return this.dbImportConfig.getInsertSql();
    }

    @Override
    public String getDeleteSqlName() {
        return this.dbImportConfig.getDeleteSqlName();
    }

    @Override
    public String getDeleteSql() {
        return this.dbImportConfig.getDeleteSql();
    }

    @Override
    public String getUpdateSqlName() {
        return this.dbImportConfig.getUpdateSqlName();
    }

    @Override
    public String getUpdateSql() {
        return this.dbImportConfig.getUpdateSql();
    }

    @Override
    public TranSQLInfo getTargetSqlInfo(TaskContext taskContext) {
        if (taskContext != null && taskContext.getTargetSqlInfo() != null) {
            return taskContext.getTargetSqlInfo();
        }
        return this.targetSqlInfo;
    }

    @Override
    public void setTargetSqlInfo(TranSQLInfo targetSqlInfo) {
        this.targetSqlInfo = targetSqlInfo;
    }

    @Override
    public TranSQLInfo getTargetUpdateSqlInfo(TaskContext taskContext) {
        if (taskContext != null && taskContext.getTargetUpdateSqlInfo() != null) {
            return taskContext.getTargetUpdateSqlInfo();
        }
        return this.targetUpdateSqlInfo;
    }

    @Override
    public void setTargetUpdateSqlInfo(TranSQLInfo sqlInfo) {
        this.targetUpdateSqlInfo = sqlInfo;
    }

    @Override
    public TranSQLInfo getTargetDeleteSqlInfo(TaskContext taskContext) {
        if (taskContext != null && taskContext.getTargetDeleteSqlInfo() != null) {
            return taskContext.getTargetDeleteSqlInfo();
        }
        return this.targetDeleteSqlInfo;
    }

    @Override
    public void setTargetDeleteSqlInfo(TranSQLInfo sqlInfo) {
        this.targetDeleteSqlInfo = sqlInfo;
    }
}

