/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.context.ImportContext;

public class TranErrorWrapper {
    protected ImportContext importContext;
    protected volatile Exception error;
    private Lock lock = new ReentrantLock();

    public TranErrorWrapper(ImportContext importContext) {
        this.importContext = importContext;
    }

    public void throwError() throws Exception {
        throw this.error;
    }

    public void setError(Exception error) {
        if (this.error == null) {
            try {
                this.lock.lock();
                if (this.error == null) {
                    this.error = error;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public boolean assertCondition() {
        return TranErrorWrapper.assertCondition(this.error, this.importContext);
    }

    public boolean assertCondition(Exception e) {
        if (this.error == null && e != null) {
            this.setError(e);
        }
        return TranErrorWrapper.assertCondition(this.error, this.importContext);
    }

    public static boolean assertCondition(Throwable e, ImportContext importContext) {
        if (e != null && !importContext.isContinueOnError()) {
            return false;
        }
        return !importContext.isCurrentStoped();
    }
}

