/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.FieldMeta;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.record.RecordColumnInfo;
import org.frameworkset.tran.record.SplitKeys;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.util.annotations.DateFormateMeta;

public abstract class BaseCommonRecordDataTran
extends BaseDataTran {
    public BaseCommonRecordDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, ImportContext targetImportContext, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, targetImportContext, currentStatus);
    }

    protected void logColumnsInfo() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Export Columns is null,you can set Export Columns in importconfig or not.");
        }
    }

    protected CommonRecord buildRecord(Context context) {
        CommonRecord dataRecord = new CommonRecord();
        this.buildRecord(dataRecord, context);
        return dataRecord;
    }

    protected CommonRecord buildRecord(CommonRecord dbRecord, Context context) {
        SplitKeys splitKeys;
        boolean isSplitKeys;
        Object keys;
        String[] columns = this.targetImportContext.getExportColumns();
        boolean useResultKeys = false;
        String[] splitColumns = null;
        if (columns == null) {
            keys = this.jdbcResultSet.getKeys();
            if (keys != null) {
                isSplitKeys = keys instanceof SplitKeys;
                if (!isSplitKeys) {
                    useResultKeys = true;
                    if (keys instanceof Set) {
                        Set _keys = (Set)keys;
                        columns = _keys.toArray(new String[_keys.size()]);
                    } else {
                        columns = (String[])keys;
                    }
                } else {
                    splitKeys = (SplitKeys)keys;
                    if (splitKeys.getBaseKeys() != null) {
                        Object baseKeys = splitKeys.getBaseKeys();
                        useResultKeys = true;
                        if (baseKeys instanceof Set) {
                            Set _keys = (Set)baseKeys;
                            columns = _keys.toArray(new String[_keys.size()]);
                        } else {
                            columns = (String[])baseKeys;
                        }
                    }
                    splitColumns = splitKeys.getSplitKeys();
                }
            } else {
                this.logColumnsInfo();
            }
        } else {
            keys = this.jdbcResultSet.getKeys();
            if (keys != null && (isSplitKeys = keys instanceof SplitKeys)) {
                splitKeys = (SplitKeys)keys;
                splitColumns = splitKeys.getSplitKeys();
            }
        }
        TranMeta metaData = context.getMetaData();
        Boolean useJavaName = context.getUseJavaName();
        Boolean useLowcase = context.getUseLowcase();
        if (useJavaName == null) {
            useJavaName = false;
        }
        if (useLowcase == null) {
            useLowcase = false;
        }
        Object temp = null;
        HashMap<String, Object> addedFields = new HashMap<String, Object>();
        List<FieldMeta> fieldValueMetas = context.getFieldValues();
        this.appendFieldValues(dbRecord, columns, fieldValueMetas, addedFields, useResultKeys, context);
        this.appendSplitFieldValues(dbRecord, splitColumns, addedFields, context);
        fieldValueMetas = context.getESJDBCFieldValues();
        this.appendFieldValues(dbRecord, columns, fieldValueMetas, addedFields, useResultKeys, context);
        String varName = null;
        String colName = null;
        for (int i = 0; columns != null && i < columns.length; ++i) {
            colName = columns[i];
            FieldMeta fieldMeta = context.getMappingName(colName);
            if (fieldMeta != null) {
                if (fieldMeta.getIgnore() != null && fieldMeta.getIgnore().booleanValue()) continue;
                varName = fieldMeta.getTargetFieldName();
                if (varName == null || varName.equals("")) {
                    throw new ElasticSearchException("fieldName[" + colName + "]\u540d\u79f0\u6620\u5c04\u914d\u7f6e\u9519\u8bef\uff1avarName=" + varName);
                }
            } else {
                varName = useResultKeys && metaData != null && metaData.getColumnCount() > 0 ? (useJavaName.booleanValue() ? metaData.getColumnJavaNameByIndex(i) : (useLowcase == false ? colName : metaData.getColumnLabelLowerByIndex(i))) : colName;
            }
            if (addedFields.get(varName) != null) continue;
            int sqlType = useResultKeys && metaData != null ? metaData.getColumnTypeByIndex(i) : -1;
            temp = this.jdbcResultSet.getValue(colName, sqlType);
            RecordColumnInfo recordColumnInfo = null;
            if (temp == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u672a\u6307\u5b9a[\u7ed1\u5b9a\u53d8\u91cf\uff1a{},\u6570\u636e\u6e90\u5217\u540d\uff1a{}]\u7684\u503c\uff01", (Object)varName, (Object)colName);
                }
            } else if (temp instanceof Date) {
                DateFormateMeta dateFormateMeta;
                DateFormat dateFormat = null;
                if (fieldMeta != null && (dateFormateMeta = fieldMeta.getDateFormateMeta()) != null) {
                    dateFormat = dateFormateMeta.toDateFormat();
                }
                if (dateFormat == null) {
                    dateFormat = context.getDateFormat();
                }
                recordColumnInfo = new RecordColumnInfo();
                recordColumnInfo.setDateTag(true);
                recordColumnInfo.setDateFormat(dateFormat);
            }
            dbRecord.addData(varName, temp, recordColumnInfo);
        }
        if (splitColumns != null && splitColumns.length > 0) {
            this.handleIgnoreFieldsAgain();
        }
        return dbRecord;
    }

    protected void handleIgnoreFieldsAgain() {
    }
}

