/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.runtime.log;

import bboss.org.apache.velocity.runtime.RuntimeServices;
import bboss.org.apache.velocity.runtime.log.LogChute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkLogChute
implements LogChute {
    public static final String RUNTIME_LOG_JDK_LOGGER = "runtime.log.logsystem.jdk.logger";
    public static final String RUNTIME_LOG_JDK_LOGGER_LEVEL = "runtime.log.logsystem.jdk.logger.level";
    public static final String DEFAULT_LOG_NAME = "bboss.org.apache.velocity";
    protected Logger logger = null;

    @Override
    public void init(RuntimeServices rs) {
        String name = (String)rs.getProperty(RUNTIME_LOG_JDK_LOGGER);
        if (name == null) {
            name = DEFAULT_LOG_NAME;
        }
        this.logger = LoggerFactory.getLogger((String)name);
    }

    @Override
    public void log(int level, String message) {
        this.log(level, message, null);
    }

    @Override
    public void log(int level, String message, Throwable t) {
        switch (level) {
            case 2: {
                if (t == null) {
                    this.logger.warn(message);
                    break;
                }
                this.logger.warn(message, t);
                break;
            }
            case 1: {
                if (t == null) {
                    this.logger.info(message);
                    break;
                }
                this.logger.info(message, t);
                break;
            }
            case 0: {
                if (t == null) {
                    this.logger.debug(message);
                    break;
                }
                this.logger.debug(message, t);
                break;
            }
            case -1: {
                if (t == null) {
                    this.logger.trace(message);
                    break;
                }
                this.logger.trace(message, t);
                break;
            }
            case 3: {
                if (t == null) {
                    this.logger.error(message);
                    break;
                }
                this.logger.error(message, t);
                break;
            }
            default: {
                if (t == null) {
                    this.logger.debug(message);
                    break;
                }
                this.logger.debug(message, t);
            }
        }
    }

    @Override
    public boolean isLevelEnabled(int level) {
        switch (level) {
            case 2: {
                return this.logger.isWarnEnabled();
            }
            case 1: {
                return this.logger.isInfoEnabled();
            }
            case 0: {
                return this.logger.isDebugEnabled();
            }
            case -1: {
                return this.logger.isTraceEnabled();
            }
            case 3: {
                return this.logger.isErrorEnabled();
            }
        }
        return this.logger.isDebugEnabled();
    }
}

