/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.runtime.log;

import bboss.org.apache.velocity.runtime.RuntimeServices;
import bboss.org.apache.velocity.runtime.log.LogChute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsLogLogChute
implements LogChute {
    public static final String LOGCHUTE_COMMONS_LOG_NAME = "runtime.log.logsystem.commons.logging.name";
    public static final String DEFAULT_LOG_NAME = "bboss.org.apache.velocity";
    protected Logger log;

    @Override
    public void init(RuntimeServices rs) throws Exception {
        String name = (String)rs.getProperty(LOGCHUTE_COMMONS_LOG_NAME);
        if (name == null) {
            name = DEFAULT_LOG_NAME;
        }
        this.log = LoggerFactory.getLogger((String)name);
        this.log(0, "CommonsLogLogChute name is '" + name + "'");
    }

    @Override
    public void log(int level, String message) {
        switch (level) {
            case 2: {
                this.log.warn(message);
                break;
            }
            case 1: {
                this.log.info(message);
                break;
            }
            case -1: {
                this.log.trace(message);
                break;
            }
            case 3: {
                this.log.error(message);
                break;
            }
            default: {
                this.log.debug(message);
            }
        }
    }

    @Override
    public void log(int level, String message, Throwable t) {
        switch (level) {
            case 2: {
                this.log.warn(message, t);
                break;
            }
            case 1: {
                this.log.info(message, t);
                break;
            }
            case -1: {
                this.log.trace(message, t);
                break;
            }
            case 3: {
                this.log.error(message, t);
                break;
            }
            default: {
                this.log.debug(message, t);
            }
        }
    }

    @Override
    public boolean isLevelEnabled(int level) {
        switch (level) {
            case 0: {
                return this.log.isDebugEnabled();
            }
            case 1: {
                return this.log.isInfoEnabled();
            }
            case -1: {
                return this.log.isTraceEnabled();
            }
            case 2: {
                return this.log.isWarnEnabled();
            }
            case 3: {
                return this.log.isErrorEnabled();
            }
        }
        return true;
    }
}

