/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import com.frameworkset.util.FileMIMETypes;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.frameworkset.cache.FileContentCache;
import org.frameworkset.util.io.ClassPathResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static Logger log = LoggerFactory.getLogger(FileContentCache.class);
    private static final ListResourceBundle mimeTypes = new FileMIMETypes();
    public static String apppath;
    private static final int EOF = -1;

    public static String getMimeType(String fileExt) {
        try {
            return mimeTypes.getString(fileExt);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getMimeTypeByleName(String fileName) {
        try {
            String fileExt = FileUtil.getFileExtByFileName(fileName);
            return mimeTypes.getString(fileExt);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static final String getOS() {
        return System.getProperty("os.name");
    }

    public static final boolean isWindows() {
        return FileUtil.getOS().startsWith("Windows");
    }

    public static final boolean isLinux() {
        return FileUtil.getOS().startsWith("Linux");
    }

    private static File computeApplicationDir(URL location, File defaultDir) {
        if (location == null) {
            System.out.println("Warning: Cannot locate the program directory. Assuming default.");
            return defaultDir;
        }
        if (!"file".equalsIgnoreCase(location.getProtocol())) {
            System.out.println("Warning: Unrecognized location type. Assuming default.");
            return new File(".");
        }
        String file = location.getFile();
        if (!file.endsWith(".jar") && !file.endsWith(".zip")) {
            try {
                return new File(URLDecoder.decode(location.getFile(), "UTF-8")).getParentFile().getParentFile();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Warning: Unrecognized location type. Assuming default.");
                return new File(location.getFile());
            }
        }
        try {
            File path = null;
            path = !FileUtil.isLinux() ? new File(URLDecoder.decode(location.toExternalForm().substring(6), "UTF-8")).getParentFile().getParentFile() : new File(URLDecoder.decode(location.toExternalForm().substring(5), "UTF-8")).getParentFile().getParentFile();
            return path;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.out.println("Warning: Unrecognized location type. Assuming default.");
            return new File(location.getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder read(String file) throws Exception {
        StringBuilder stringbuffer;
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        String s = null;
        try {
            in = new BufferedReader(new FileReader(file));
            while ((s = in.readLine()) != null) {
                sb.append(s).append('\n');
            }
            stringbuffer = sb;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return stringbuffer;
    }

    public static Properties getProperties(String propsFile) throws Exception {
        return FileUtil.getProperties(propsFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String propsFile, boolean addToSystemProps) throws Exception {
        FileInputStream fis = null;
        Properties props = null;
        try {
            fis = new FileInputStream(propsFile);
            props = addToSystemProps ? new Properties(System.getProperties()) : new Properties();
            props.load(fis);
            fis.close();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return props;
    }

    public static File createNewFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            file.createNewFile();
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return file;
        }
    }

    public static File createNewFileOnExist(String filePath) {
        File dir;
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        if (!(dir = file.getParentFile()).exists()) {
            dir.mkdirs();
        }
        try {
            file.createNewFile();
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return file;
        }
    }

    public static File createNewDirectory(String directorPath) {
        File dir = new File(directorPath);
        if (dir.exists()) {
            return dir;
        }
        dir.mkdirs();
        return dir;
    }

    public static void copy(File sourceFile, String destinction) throws IOException {
        if (!sourceFile.exists()) {
            return;
        }
        File dest_f = new File(destinction);
        if (!dest_f.exists()) {
            dest_f.mkdirs();
        }
        if (sourceFile.isDirectory()) {
            File[] files = sourceFile.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                File temp = files[i];
                if (temp.isDirectory()) {
                    String fileName = temp.getName();
                    FileUtil.copy(temp, destinction + "/" + fileName);
                    continue;
                }
                FileUtil.fileCopy(temp.getAbsolutePath(), destinction + "/" + temp.getName());
            }
        } else {
            File destinctionFile = new File(destinction);
            if (!destinctionFile.exists()) {
                destinctionFile.mkdirs();
            }
            String dest = destinction + "/" + sourceFile.getName();
            FileUtil.fileCopy(sourceFile, dest);
        }
    }

    public static void copy(String source, String destinction) throws IOException {
        File sourceFile = new File(source);
        FileUtil.copy(sourceFile, destinction);
    }

    public static void makeFile(String destinctionFile) {
        File f = new File(destinctionFile);
        File pf = f.getParentFile();
        if (f.exists()) {
            return;
        }
        if (!pf.exists()) {
            pf.mkdirs();
        }
        try {
            f.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void fileCopy(String sourcefile, String destinctionFile) throws IOException {
        FileUtil.fileCopy(new File(sourcefile), destinctionFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileCopy(File sourcefile, String destinctionFile) throws IOException {
        FileInputStream stFileInputStream = null;
        FileOutputStream stFileOutputStream = null;
        try {
            int bytesRead;
            FileUtil.makeFile(destinctionFile);
            stFileInputStream = new FileInputStream(sourcefile);
            stFileOutputStream = new FileOutputStream(destinctionFile);
            int arraySize = 1024;
            byte[] buffer = new byte[arraySize];
            while ((bytesRead = stFileInputStream.read(buffer)) != -1) {
                stFileOutputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stFileInputStream != null) {
                try {
                    stFileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stFileOutputStream != null) {
                try {
                    stFileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileCopy(File sourcefile, File destinctionFile) throws IOException {
        FileInputStream stFileInputStream = null;
        FileOutputStream stFileOutputStream = null;
        try {
            int bytesRead;
            stFileInputStream = new FileInputStream(sourcefile);
            stFileOutputStream = new FileOutputStream(destinctionFile);
            int arraySize = 1024;
            byte[] buffer = new byte[arraySize];
            while ((bytesRead = stFileInputStream.read(buffer)) != -1) {
                stFileOutputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stFileInputStream != null) {
                try {
                    stFileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stFileOutputStream != null) {
                try {
                    stFileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getFileContent(String filePath, String charSet) throws IOException {
        return FileUtil.getFileContent(new File(filePath), charSet);
    }

    public static String getFileContent(File file, String charSet) throws IOException {
        ByteArrayOutputStream swriter = null;
        OutputStream temp = null;
        FileInputStream reader = null;
        try {
            reader = new FileInputStream(file);
            swriter = new ByteArrayOutputStream();
            temp = new BufferedOutputStream(swriter);
            int len = 0;
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)reader).read(buffer)) > 0) {
                temp.write(buffer, 0, len);
            }
            temp.flush();
            if (charSet != null && !charSet.equals("")) {
                String string = swriter.toString(charSet);
                return string;
            }
            String string = swriter.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            log.error("Get File Content Error:", (Throwable)e);
            String string = "";
            return string;
        }
        catch (IOException e) {
            log.error("Get File Content Error:", (Throwable)e);
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    ((InputStream)reader).close();
                }
                catch (IOException iOException) {}
            }
            if (swriter != null) {
                try {
                    swriter.close();
                }
                catch (IOException iOException) {}
            }
            if (temp != null) {
                try {
                    temp.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getFileContent(InputStream reader, String charSet) throws IOException {
        ByteArrayOutputStream swriter = null;
        BufferedOutputStream temp = null;
        try {
            swriter = new ByteArrayOutputStream();
            temp = new BufferedOutputStream(swriter);
            int len = 0;
            byte[] buffer = new byte[1024];
            while ((len = reader.read(buffer)) > 0) {
                ((OutputStream)temp).write(buffer, 0, len);
            }
            ((OutputStream)temp).flush();
            if (charSet != null && !charSet.equals("")) {
                String string = swriter.toString(charSet);
                return string;
            }
            String string = swriter.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            log.error("Get File Content Error:", (Throwable)e);
            String string = "";
            return string;
        }
        catch (IOException e) {
            log.error("Get File Content Error:", (Throwable)e);
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (swriter != null) {
                try {
                    swriter.close();
                }
                catch (IOException iOException) {}
            }
            if (temp != null) {
                try {
                    ((OutputStream)temp).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getContent(String file, String charSet) throws IOException {
        InputStream input = null;
        String content = null;
        if (!file.startsWith("file:")) {
            ClassPathResource resource = new ClassPathResource(file);
            input = resource.getInputStream();
            content = FileUtil.getFileContent(input, charSet);
        } else {
            content = FileUtil.getFileContent(file.substring(5), charSet);
        }
        return content;
    }

    public static void main(String[] args) {
        File f = new File("d:/");
        File pf = f.getParentFile();
        System.out.println(pf + "/aaa");
    }

    public Vector getFileNames(String pathName, String suffix) throws Exception {
        Vector<String> v = new Vector<String>();
        String[] fileNames = null;
        File file = new File(pathName);
        fileNames = file.list();
        if (fileNames == null) {
            throw new Exception();
        }
        for (int i = 0; i < fileNames.length; ++i) {
            if (!suffix.equals("*") && !fileNames[i].toLowerCase().endsWith(suffix.toLowerCase())) continue;
            v.addElement(fileNames[i]);
        }
        return v;
    }

    public static void deleteFile(String path) {
        FileUtil.deleteFile(new File(path));
    }

    public static void deleteFile(File file) {
        if (!file.exists() || file.isFile()) {
            return;
        }
        if (file.isDirectory()) {
            FileUtil.deleteSubfiles(file.getAbsolutePath());
        }
        file.delete();
    }

    public static void removeFileOrDirectory(String path) {
        FileUtil.removeFileOrDirectory(new File(path));
    }

    public static void removeFileOrDirectory(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            FileUtil.deleteSubfiles(file.getAbsolutePath());
        }
        file.delete();
    }

    public static void deleteFileOnly(String path) {
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }

    public static void moveFile(String sourceFileName, String destPath) throws Exception {
        File src = new File(sourceFileName);
        if (!src.exists()) {
            throw new Exception("save file[" + sourceFileName + "] to file[" + destPath + "] failed:" + sourceFileName + " not exist.");
        }
        try {
            FileUtil.fileCopy(sourceFileName, destPath);
        }
        catch (Exception e) {
            System.out.println("save file[" + sourceFileName + "] to file[" + destPath + "]" + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void renameFile(String source, String dest) {
        File file = new File(source);
        file.renameTo(new File(dest));
    }

    public static void renameFile(File source, File dest) {
        source.renameTo(dest);
    }

    public static void bakFile(String source, String dest) throws IOException {
        File file = new File(source);
        boolean state = file.renameTo(new File(dest));
        if (!state) {
            FileUtil.fileCopy(source, dest);
            FileUtil.deleteFileOnly(source);
        }
    }

    public static void moveSubFiles(String sourceFileName, String destPath) {
        File src = new File(sourceFileName);
        File dest = new File(destPath);
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if (src.isFile()) {
            return;
        }
        File[] files = src.listFiles();
        String destFile = null;
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i].isDirectory()) {
                String temp_name = files[i].getName();
                try {
                    FileUtil.moveSubFiles(files[i].getAbsolutePath(), destPath + "/" + temp_name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            destFile = destPath + "/" + files[i].getName();
            try {
                FileUtil.moveFile(files[i].getAbsolutePath(), destFile);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List upzip(ZipInputStream zip, String destPath) throws ZipException, IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        ZipEntry azipfile = null;
        while ((azipfile = zip.getNextEntry()) != null) {
            String name = azipfile.getName();
            fileNames.add(name);
            if (azipfile.isDirectory()) continue;
            File targetFile = new File(destPath, name);
            targetFile.getParentFile().mkdirs();
            if (targetFile.exists()) {
                targetFile.delete();
            }
            targetFile.createNewFile();
            BufferedOutputStream diskfile = null;
            FileOutputStream out = null;
            try {
                int read;
                out = new FileOutputStream(targetFile);
                diskfile = new BufferedOutputStream(out);
                byte[] buffer = new byte[1024];
                while ((read = zip.read(buffer)) != -1) {
                    diskfile.write(buffer, 0, read);
                }
                diskfile.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (diskfile == null) continue;
                    diskfile.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String sourceFileName, String destPath) throws ZipException, IOException {
        ZipFile zf = null;
        try {
            zf = new ZipFile(sourceFileName);
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry zipEnt = en.nextElement();
                FileUtil.saveEntry(destPath, zipEnt, zf);
            }
        }
        finally {
            if (zf != null) {
                zf.close();
            }
        }
    }

    public static void saveEntry(String destPath, ZipEntry target, ZipFile zf) throws ZipException, IOException {
        InputStream is = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            File file = new File(destPath + "/" + target.getName());
            if (target.isDirectory()) {
                file.mkdirs();
            } else {
                int c;
                is = zf.getInputStream(target);
                bis = new BufferedInputStream(is);
                File dir = new File(file.getParent());
                dir.mkdirs();
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                while ((c = bis.read()) != -1) {
                    ((BufferedOutputStream)bos).write((byte)c);
                }
                ((BufferedOutputStream)bos).flush();
            }
        }
        catch (ZipException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean createDir(String dirName) {
        File file = new File(dirName);
        if (!file.exists()) {
            return file.mkdir();
        }
        return true;
    }

    public static void createFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Create file fail!");
        }
    }

    public static void writeFile(String fileName, String text) throws IOException {
        FileWriter fw = new FileWriter(fileName, true);
        try {
            fw.write(text, 0, text.length());
        }
        catch (IOException ioe) {
            throw new IOException("Write text to " + fileName + " fail!");
        }
        finally {
            fw.close();
        }
    }

    public static void writeFile(String fileName, String text, String encode) throws IOException {
        FileUtil.writeFile(new File(fileName), text, encode);
    }

    public static void writeFile(File file, String text, String encode) throws IOException {
        Writer fw = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)out, encode == null ? "UTF-8" : encode));
            fw.write(text, 0, text.length());
            fw.flush();
        }
        catch (IOException ioe) {
            throw new IOException("Write text to " + file.getPath() + " fail!");
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (Exception exception) {}
            try {
                fw.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void writeFile(String fileName, String text, boolean isAppend) throws IOException {
        FileWriter fw = new FileWriter(fileName, isAppend);
        try {
            fw.write(text, 0, text.length());
        }
        catch (IOException ioe) {
            throw new IOException("Write text to " + fileName + " fail!");
        }
        finally {
            fw.close();
        }
    }

    public static void deleteSubfiles(String publishTemppath) {
        File file = new File(publishTemppath);
        if (!file.exists() || file.isFile()) {
            return;
        }
        File[] files = file.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            File temp = files[i];
            if (temp.isDirectory()) {
                FileUtil.deleteSubfiles(temp.getAbsolutePath());
            }
            temp.delete();
        }
    }

    public static String getFileExtByFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        int idx = fileName.lastIndexOf(".");
        if (idx != -1) {
            return fileName.substring(idx + 1);
        }
        return "";
    }

    public static String getFileContent(String filePath) throws IOException {
        StringWriter swriter = null;
        FileReader reader = null;
        try {
            reader = new FileReader(filePath);
            swriter = new StringWriter();
            int len = 0;
            char[] buffer = new char[1024];
            while ((len = reader.read(buffer)) != -1) {
                ((Writer)swriter).write(buffer, 0, len);
            }
            String string = ((Object)swriter).toString();
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
            if (swriter != null) {
                try {
                    ((Writer)swriter).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean hasSubDirectory(String path, String uri) {
        File file = null;
        file = uri == null || uri.trim().length() == 0 ? new File(path) : new File(path, uri);
        if (!file.exists() || file.isFile()) {
            return false;
        }
        File[] subFiles = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        return subFiles.length > 0;
    }

    public static boolean hasSubDirectory(String path) {
        return FileUtil.hasSubDirectory(path, null);
    }

    public static boolean hasSubFiles(String path, String uri) {
        File file = new File(path, uri);
        if (!file.exists() || file.isFile()) {
            return false;
        }
        File[] subFiles = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isDirectory();
            }
        });
        return subFiles.length > 0;
    }

    public static boolean hasSubFiles(String path) {
        File file = new File(path);
        if (!file.exists() || file.isFile()) {
            return false;
        }
        File[] subFiles = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isDirectory();
            }
        });
        return subFiles.length > 0;
    }

    public static File[] getSubDirectories(String parentpath, String uri) {
        File file = null;
        file = uri == null || uri.trim().length() == 0 ? new File(parentpath) : new File(parentpath, uri);
        if (!file.exists() || file.isFile()) {
            return null;
        }
        File[] subFiles = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        return subFiles;
    }

    public static File[] getSubDirectories(String parentpath) {
        return FileUtil.getSubDirectories(parentpath, null);
    }

    public static File[] getSubFiles(String parentpath) {
        return FileUtil.getSubFiles(parentpath, (String)null);
    }

    public static File[] getSubFiles(String parentpath, String uri) {
        File file = null;
        file = uri == null || uri.trim().length() == 0 ? new File(parentpath) : new File(parentpath, uri);
        if (!file.exists() || file.isFile()) {
            return null;
        }
        File[] subFiles = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
        return subFiles;
    }

    public static File[] getSubFiles(String parentpath, FileFilter fileFilter) {
        return FileUtil.getSubFiles(parentpath, null, fileFilter);
    }

    public static File[] getSubFiles(String parentpath, String uri, FileFilter fileFilter) {
        File file = null;
        file = uri == null || uri.trim().length() == 0 ? new File(parentpath) : new File(parentpath, uri);
        if (!file.exists() || file.isFile()) {
            return null;
        }
        File[] files = null;
        files = fileFilter != null ? file.listFiles(fileFilter) : file.listFiles();
        int rLen = 0;
        for (int i = 0; files != null && i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            files[rLen] = files[i];
            ++rLen;
        }
        File[] r = new File[rLen];
        System.arraycopy(files, 0, r, 0, rLen);
        return r;
    }

    public static File[] getSubDirectorieAndFiles(String parentpath) {
        return FileUtil.getSubDirectorieAndFiles(parentpath, null, null);
    }

    public static File[] getSubDirectorieAndFiles(String parentpath, String uri) {
        return FileUtil.getSubDirectorieAndFiles(parentpath, uri, null);
    }

    public static File[] getSubDirectorieAndFiles(String parentpath, FileFilter fileFilter) {
        return FileUtil.getSubDirectorieAndFiles(parentpath, null, fileFilter);
    }

    public static File[] getSubDirectorieAndFiles(String parentpath, String uri, FileFilter fileFilter) {
        File file = null;
        file = uri == null || uri.trim().length() == 0 ? new File(parentpath) : new File(parentpath, uri);
        if (!file.exists() || file.isFile()) {
            return null;
        }
        if (fileFilter != null) {
            return file.listFiles(fileFilter);
        }
        return file.listFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file) {
        StringWriter swriter = null;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            swriter = new StringWriter();
            int len = 0;
            char[] buffer = new char[1024];
            while ((len = reader.read(buffer)) > 0) {
                ((Writer)swriter).write(buffer, 0, len);
            }
            ((Writer)swriter).flush();
            String string = ((Object)swriter).toString();
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
            if (swriter != null) {
                try {
                    ((Writer)swriter).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] readFully(InputStream in) throws IOException {
        if (in instanceof ByteArrayInputStream) {
            int size = in.available();
            byte[] bytes = new byte[size];
            int numRead = 0;
            for (int offset = 0; offset < size && (numRead = in.read(bytes, offset, size - offset)) >= 0; offset += numRead) {
            }
            return bytes;
        }
        byte[] xfer = new byte[2048];
        ByteArrayOutputStream out = new ByteArrayOutputStream(xfer.length);
        int bytesRead = in.read(xfer, 0, xfer.length);
        while (bytesRead >= 0) {
            if (bytesRead > 0) {
                out.write(xfer, 0, bytesRead);
            }
            bytesRead = in.read(xfer, 0, xfer.length);
        }
        in.close();
        out.close();
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFully(File file) throws IOException {
        FileInputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = new FileInputStream(file);
            byte[] xfer = new byte[2048];
            out = new ByteArrayOutputStream(xfer.length);
            int bytesRead = in.read(xfer, 0, xfer.length);
            while (bytesRead >= 0) {
                if (bytesRead > 0) {
                    out.write(xfer, 0, bytesRead);
                }
                bytesRead = in.read(xfer, 0, xfer.length);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(File source, String basePath, ZipOutputStream zos) throws IOException {
        File[] files = null;
        files = source.isDirectory() ? source.listFiles() : new File[]{source};
        byte[] buf = new byte[1024];
        int length = 0;
        for (File file : files) {
            String pathName;
            if (file.isDirectory()) {
                pathName = file.getPath().substring(basePath.length() + 1) + "/";
                zos.putNextEntry(new ZipEntry(pathName));
                FileUtil.zipFile(file, basePath, zos);
                continue;
            }
            pathName = file.getPath().substring(basePath.length() + 1);
            BufferedInputStream bis = null;
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                bis = new BufferedInputStream(is);
                zos.putNextEntry(new ZipEntry(pathName));
                while ((length = bis.read(buf)) > 0) {
                    zos.write(buf, 0, length);
                }
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(File f, File destfile) {
        BufferedOutputStream out = null;
        ZipOutputStream zipOut = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(destfile));
            zipOut = new ZipOutputStream(out);
            String basePath = f.isDirectory() ? f.getPath() : f.getParent();
            FileUtil.zipFile(f, basePath, zipOut);
            File file = destfile;
            return file;
        }
        catch (IOException e) {
            File file = null;
            return file;
        }
        finally {
            if (zipOut != null) {
                try {
                    zipOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(File f, String destfile) {
        FilterOutputStream out = null;
        ZipOutputStream zipOut = null;
        try {
            File ret = new File(destfile);
            out = new BufferedOutputStream(new FileOutputStream(ret));
            zipOut = new ZipOutputStream(out);
            String basePath = f.isDirectory() ? f.getPath() : f.getParent();
            FileUtil.zipFile(f, basePath, zipOut);
            File file = ret;
            return file;
        }
        catch (IOException e) {
            File file = null;
            return file;
        }
        finally {
            if (zipOut != null) {
                try {
                    zipOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        try {
            File parent;
            URL location = FileUtil.class.getProtectionDomain().getCodeSource().getLocation();
            File appDir = FileUtil.computeApplicationDir(location, new File("."));
            if (appDir != null && appDir.exists() && (parent = appDir.getParentFile()) != null) {
                apppath = parent.getPath();
            }
        }
        catch (Throwable e) {
            log.warn("Init apppath failed:", e);
        }
    }
}

