/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.management;

import com.frameworkset.common.poolman.management.ConfigParser;
import com.frameworkset.common.poolman.sql.ParserException;
import com.frameworkset.util.SimpleStringUtil;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.frameworkset.soa.BBossStringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class PoolManConfiguration {
    private static Logger log = LoggerFactory.getLogger(PoolManConfiguration.class);
    private String configFile;
    private ConfigParser handler;
    private ArrayList datasources;
    private ArrayList genericObjects;
    private static String sqlMappingDir;
    private static long refresh_interval;
    private static boolean columnNameMapping;
    private boolean useJMX;
    public static boolean needtableinfo;
    public static String jndi_principal;
    public static String jndi_credentials;
    private String[] filterdbname;
    private String dbnamespace;
    public Map<String, String> adaptors;
    private static Object lock;

    public static String getSqlMappingDir() {
        return sqlMappingDir;
    }

    public static void setSqlMappingDir(String sqlMappingDir) {
        PoolManConfiguration.sqlMappingDir = sqlMappingDir;
    }

    public static long getRefresh_interval() {
        return refresh_interval;
    }

    public static void setRefresh_interval(Long refresh_interval) {
        if (refresh_interval != null) {
            PoolManConfiguration.refresh_interval = refresh_interval;
        }
    }

    public static boolean isColumnNameMapping() {
        return columnNameMapping;
    }

    public static void setColumnNameMapping(boolean columnNameMapping) {
        PoolManConfiguration.columnNameMapping = columnNameMapping;
    }

    public PoolManConfiguration(String configFile, String dbname) {
        String[] stringArray;
        if (dbname == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = dbname;
        }
        this(configFile, null, stringArray);
    }

    public PoolManConfiguration(String configFile, String dbnamespace, String[] dbnames) {
        this.useJMX = false;
        this.filterdbname = null;
        this.adaptors = new HashMap<String, String>();
        this.configFile = configFile;
        this.datasources = new ArrayList();
        this.genericObjects = new ArrayList();
        this.filterdbname = dbnames;
        this.dbnamespace = dbnamespace;
    }

    public PoolManConfiguration(String configFile) {
        this(configFile, null);
    }

    public boolean isUsingJMX() {
        return this.handler.isManagementJMX();
    }

    public boolean loadConfiguration(Map context) throws Exception {
        try {
            this.parseXML(context);
            return true;
        }
        catch (NullPointerException ne) {
            ParserException e = new ParserException("Load datasource Configuration from default bboss persistent config file,please config and start datasource follow document\uff1ahttps://doc.bbossgroups.com/#/persistent/PersistenceLayer1");
            log.error("", (Throwable)e);
        }
        catch (Exception e) {
            ParserException ex = new ParserException("Load datasource Configuration from default bboss persistent config file, please config and start datasource follow document\uff1ahttps://doc.bbossgroups.com/#/persistent/PersistenceLayer1", e);
            log.error("", (Throwable)ex);
        }
        return false;
    }

    public String toString() {
        try {
            StringBuilder builder = new StringBuilder();
            BBossStringWriter writer = new BBossStringWriter(builder);
            writer.write("adaptors:\r\n");
            SimpleStringUtil.object2json(this.adaptors, (Writer)writer);
            writer.write("\r\ndatasources:\r\n");
            SimpleStringUtil.object2json((Object)this.datasources, (Writer)writer);
            writer.write("\r\nenericObjects:\r\n");
            SimpleStringUtil.object2json((Object)this.genericObjects, (Writer)writer);
            writer.flush();
            return builder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public ArrayList getDataSources() {
        return this.datasources;
    }

    public ArrayList getGenericPools() {
        return this.genericObjects;
    }

    public Properties getAdminProperties() {
        return this.handler.getAdminProps();
    }

    private void initConfig(Map context) {
        Boolean columnLableUpperCase;
        String dbInfoEncryptClass;
        LinkedHashMap<String, String> adaptors = new LinkedHashMap<String, String>();
        String dbAdaptor = (String)context.get("dbAdaptor");
        String driver = (String)context.get("driver");
        if (dbAdaptor != null && !dbAdaptor.equals("")) {
            adaptors.put(driver, dbAdaptor);
            String dbtype = (String)context.get("dbtype");
            if (dbtype != null && !dbtype.equals("")) {
                adaptors.put(dbtype, dbAdaptor);
            }
        }
        this.adaptors = adaptors;
        ArrayList<Properties> datasources = new ArrayList<Properties>();
        Properties datasource = new Properties();
        String external = (String)context.get("external");
        datasource.put("external", external);
        String dbname = (String)context.get("dbname");
        datasource.put("dbname", dbname);
        datasource.put("loadmetadata", "false");
        String dbname_datasource_jndiname = (String)context.get("dbname_datasource_jndiname");
        datasource.put("jndiName".toLowerCase(), dbname_datasource_jndiname);
        datasource.put("autoprimarykey".toLowerCase(), "false");
        String encryptdbinfo = (String)context.get("encryptdbinfo");
        datasource.put("encryptdbinfo".toLowerCase(), encryptdbinfo);
        String cachequerymetadata = (String)context.get("cachequerymetadata");
        datasource.put("cachequerymetadata".toLowerCase(), cachequerymetadata);
        datasource.put("driver".toLowerCase(), driver);
        String enablejta = (String)context.get("enablejta");
        datasource.put("enablejta".toLowerCase(), enablejta);
        String jdbcurl = (String)context.get("jdbcurl");
        datasource.put("url".toLowerCase(), jdbcurl);
        String username = (String)context.get("username");
        datasource.put("username".toLowerCase(), username);
        String password = (String)context.get("password");
        datasource.put("password".toLowerCase(), password);
        String txIsolationLevel = (String)context.get("txIsolationLevel");
        datasource.put("txIsolationLevel".toLowerCase(), txIsolationLevel);
        datasource.put("nativeResults".toLowerCase(), "true");
        datasource.put("poolPreparedStatements".toLowerCase(), "false");
        String initialConnections = (String)context.get("initialConnections");
        datasource.put("initialConnections".toLowerCase(), initialConnections);
        String minimumSize = (String)context.get("minimumSize");
        datasource.put("minimumSize".toLowerCase(), minimumSize);
        String maximumSize = (String)context.get("maximumSize");
        datasource.put("maximumSize".toLowerCase(), maximumSize);
        String removeAbandoned = (String)context.get("removeAbandoned");
        datasource.put("removeAbandoned".toLowerCase(), removeAbandoned);
        String userTimeout = (String)context.get("userTimeout");
        datasource.put("userTimeout".toLowerCase(), userTimeout);
        String logAbandoned = (String)context.get("logAbandoned");
        datasource.put("logAbandoned".toLowerCase(), logAbandoned);
        String readOnly = (String)context.get("readOnly");
        datasource.put("readOnly".toLowerCase(), readOnly);
        String skimmerFrequency = (String)context.get("skimmerFrequency");
        datasource.put("skimmerFrequency".toLowerCase(), skimmerFrequency);
        String connectionTimeout = (String)context.get("connectionTimeout");
        datasource.put("connectionTimeout".toLowerCase(), connectionTimeout);
        String shrinkBy = (String)context.get("shrinkBy");
        datasource.put("shrinkBy".toLowerCase(), shrinkBy);
        String testWhileidle = (String)context.get("testWhileidle");
        datasource.put("testWhileidle".toLowerCase(), testWhileidle);
        datasource.put("keygenerate".toLowerCase(), "composite");
        String maxWait = (String)context.get("maxWait");
        datasource.put("maxWait".toLowerCase(), maxWait);
        String validationQuery = (String)context.get("validationQuery");
        datasource.put("validationQuery".toLowerCase(), validationQuery);
        String showsql = (String)context.get("showsql");
        datasource.put("showsql".toLowerCase(), showsql);
        String externaljndiName = (String)context.get("externaljndiName");
        if (externaljndiName != null && !externaljndiName.equals("")) {
            datasource.put("externaljndiName".toLowerCase(), externaljndiName);
        }
        String usepool = (String)context.get("usepool");
        datasource.put("usepool".toLowerCase(), usepool);
        datasource.put("RETURN_GENERATED_KEYS".toLowerCase(), "true");
        Integer queryfetchsize = (Integer)context.get("queryfetchsize");
        if (queryfetchsize != null && queryfetchsize != 0) {
            datasource.put("queryfetchsize".toLowerCase(), queryfetchsize + "");
        }
        if (SimpleStringUtil.isNotEmpty((String)(dbInfoEncryptClass = (String)context.get("dbInfoEncryptClass")))) {
            datasource.put("dbInfoEncryptClass".toLowerCase(), dbInfoEncryptClass);
        }
        if ((columnLableUpperCase = (Boolean)context.get("columnLableUpperCase")) != null) {
            datasource.put("columnLableUpperCase".toLowerCase(), columnLableUpperCase + "");
        } else {
            datasource.put("columnLableUpperCase".toLowerCase(), "true");
        }
        datasources.add(datasource);
        this.datasources = datasources;
    }

    private void parseXML(Map context) throws Exception {
        if (!this.configFile.equals("poolman_template.xml")) {
            URL confURL = PoolManConfiguration.class.getClassLoader().getResource(this.configFile);
            if (confURL == null) {
                PoolManConfiguration.class.getClassLoader().getResource("/" + this.configFile);
            }
            if (confURL == null) {
                PoolManConfiguration.getTCL().getResource(this.configFile);
            }
            if (confURL == null) {
                PoolManConfiguration.getTCL().getResource("/" + this.configFile);
            }
            if (confURL == null) {
                confURL = ClassLoader.getSystemResource(this.configFile);
            }
            if (confURL == null) {
                confURL = ClassLoader.getSystemResource("/" + this.configFile);
            }
            String url = "";
            if (confURL == null) {
                url = System.getProperty("user.dir");
                url = url + "/" + this.configFile;
                log.debug("Pool Config file:" + System.getProperty("user.dir") + "/" + this.configFile);
            } else {
                url = confURL.toString();
            }
            this.handler = new ConfigParser(url, this.dbnamespace, this.filterdbname);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(url, (DefaultHandler)this.handler);
            this.adaptors = this.handler.getAdaptors();
            if (this.handler.getSqlMappingDir() != null) {
                sqlMappingDir = this.handler.getSqlMappingDir();
            }
            this.datasources = this.handler.getDataSourceProperties();
            this.genericObjects = this.handler.getGenericProperties();
        } else {
            this.initConfig(context);
        }
    }

    private static ClassLoader getTCL() throws IllegalAccessException, InvocationTargetException {
        Method method = null;
        try {
            method = Thread.class.getMethod("getContextClassLoader", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0]);
    }

    private ArrayList parseProperties(String propsfilename) throws Exception {
        HashMap<String, Properties> datasources = new HashMap<String, Properties>();
        this.getClass().getClassLoader().getParent();
        ClassLoader.getSystemClassLoader().getResource(null);
        InputStream is = null;
        Properties p = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propsfilename);
            p = new Properties();
            p.load(is);
        }
        catch (Exception e) {
            if (propsfilename.equals("poolman.props")) {
                try {
                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream("pool.props");
                    p = new Properties();
                    p.load(is);
                }
                catch (Exception e2) {
                    throw new Exception("Unable to find and read a valid datasource config file. Please ensure that 'poolman.xml' is in a directory that is in your CLASSPATH.\n");
                }
                log.warn("\nPLEASE NOTE: You should replace the pool.props file with a valid config file\n");
            }
            throw new Exception("ERROR: Unable to find and read a valid PoolMan properties file.\nPlease ensure that poolman.xml or at least " + propsfilename + " is in a directory that is in your CLASSPATH.\n");
        }
        Properties theseProps = null;
        String entrySetNumber = null;
        Enumeration<Object> enum_ = p.keys();
        while (enum_.hasMoreElements()) {
            String key;
            String adjustedKey = key = (String)enum_.nextElement();
            if (key.indexOf("_") != -1) {
                StringBuilder sb = new StringBuilder(key.substring(0, key.indexOf("_")));
                sb.append(key.substring(key.indexOf("_") + 1, key.length()));
                adjustedKey = sb.toString();
                if (!adjustedKey.toLowerCase().equals("dbname") && adjustedKey.startsWith("db")) {
                    adjustedKey = adjustedKey.substring(2, adjustedKey.length());
                }
            }
            if (adjustedKey.toLowerCase().startsWith("cacherefresh")) {
                adjustedKey = "cacherefreshinterval" + adjustedKey.substring(12, adjustedKey.length());
            }
            try {
                entrySetNumber = key.substring(key.indexOf(46) + 1, key.length());
            }
            catch (StringIndexOutOfBoundsException sbe) {
                throw new Exception("Unnumbered property in poolman.props: " + key);
            }
            theseProps = datasources.containsKey(entrySetNumber) ? (Properties)datasources.get(entrySetNumber) : new Properties();
            theseProps.setProperty(adjustedKey.substring(0, adjustedKey.indexOf(46)), p.getProperty(key));
            datasources.put(entrySetNumber, theseProps);
        }
        ArrayList<Properties> finalDataSourceList = new ArrayList<Properties>();
        Iterator iter = datasources.keySet().iterator();
        while (iter.hasNext()) {
            Properties testp = (Properties)datasources.get(iter.next());
            finalDataSourceList.add(testp);
        }
        return finalDataSourceList;
    }

    public Map<String, String> getAdaptors() {
        return this.adaptors;
    }

    public void setAdaptors(Map<String, String> adaptors) {
        this.adaptors = adaptors;
    }

    public boolean isNeedtableinfo() {
        return needtableinfo;
    }

    public void setNeedtableinfo(boolean needtableinfo) {
        PoolManConfiguration.needtableinfo = needtableinfo;
    }

    static {
        refresh_interval = 5000L;
        columnNameMapping = true;
        needtableinfo = false;
        jndi_principal = null;
        jndi_credentials = null;
        lock = new Object();
    }
}

