/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman;

import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.context.Context;
import com.frameworkset.common.poolman.DBUtil;
import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.NewSQLInfo;
import com.frameworkset.common.poolman.PagineOrderby;
import com.frameworkset.common.poolman.Param;
import com.frameworkset.common.poolman.Params;
import com.frameworkset.common.poolman.PreparedDBUtil;
import com.frameworkset.common.poolman.SetSQLParamException;
import com.frameworkset.common.poolman.sql.IdGenerator;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.orm.annotation.PrimaryKey;
import com.frameworkset.util.ColumnEditorInf;
import com.frameworkset.util.ColumnToFieldEditor;
import com.frameworkset.util.ColumnType;
import com.frameworkset.util.StringUtil;
import com.frameworkset.util.VariableHandler;
import java.io.File;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.frameworkset.persitent.type.BaseTypeMethod;
import org.frameworkset.persitent.util.SQLInfo;
import org.frameworkset.persitent.util.SQLUtil;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.util.BigFile;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.frameworkset.util.annotations.wraper.ColumnWraper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLParams {
    private PagineOrderby pagineOrderby;
    private String pretoken = "#\\[";
    private String endtoken = "\\]";
    private Map<String, Param> sqlparams = null;
    private Params realParams = null;
    private NewSQLInfo newsql = null;
    private String dbname = null;
    private static Logger log = LoggerFactory.getLogger(SQLParams.class);
    private SQLInfo oldsql = null;
    private boolean frommap = false;
    private int action = -1;
    @Deprecated
    private static final Map<String, String[][]> parserResults = new WeakHashMap<String, String[][]>();
    private static final Object lock = new Object();
    public static final String STRING = "string";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String DOUBLE = "double";
    public static final String FLOAT = "float";
    public static final String SHORT = "short";
    public static final String DATE = "date";
    public static final String TIMESTAMP = "timestamp";
    public static final String BIGDECIMAL = "bigdecimal";
    public static final String BOOLEAN = "boolean";
    public static final String BYTE = "byte";
    public static final String TIME = "time";
    public static final String BYTEARRAY = "byte[]";
    public static final String BLOBBYTEARRAY = "blobbyte[]";
    public static final String BLOBFILE = "blobfile";
    public static final String BLOB = "blob";
    public static final String CLOBFILE = "clobfile";
    public static final String CLOB = "clob";
    public static final String OBJECT = "object";
    public static final String NULL = "null";

    public void setPagineOrderby(PagineOrderby pagineOrderby) {
        this.pagineOrderby = pagineOrderby;
    }

    public String getDbname() {
        return this.dbname;
    }

    public void setDbname(String dbname) {
        this.dbname = dbname;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public NewSQLInfo getNewsql() {
        return this.newsql;
    }

    public Params getRealParams() {
        return this.realParams;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("sql{").append(this.newsql != null ? this.newsql.getNewsql() : "").append(",").append(this.pagineOrderby == null ? "" : this.pagineOrderby.toString(null)).append("},params");
        if (this.sqlparams != null && this.sqlparams.size() > 0) {
            ret.append("{");
            Set<Map.Entry<String, Param>> ent = this.sqlparams.entrySet();
            for (Map.Entry<String, Param> entry : ent) {
                ret.append(entry.getValue());
            }
            ret.append("},action{").append(PreparedDBUtil.convertOperationType(this.action)).append("},");
        }
        ret.append("Variable identity{pretoken=").append(this.pretoken).append(",endtoken=").append(this.endtoken).append("}");
        return ret.toString();
    }

    public void buildParams(String dbname) throws SetSQLParamException {
        this.buildParams(this.oldsql, dbname);
    }

    public void buildParamsNewSQLInfo(String dbname, NewSQLInfo newsql) throws SetSQLParamException {
        this.buildParams(this.oldsql, dbname, newsql);
    }

    public VelocityContext buildVelocityContext(Map<String, Param> sqlparams) {
        VelocityContext context_ = new VelocityContext();
        Param temp = null;
        if (sqlparams != null && sqlparams.size() > 0) {
            for (Map.Entry<String, Param> entry : sqlparams.entrySet()) {
                temp = entry.getValue();
                if (temp.getType().equals(NULL)) continue;
                context_.put(entry.getKey(), temp.getData());
            }
        }
        return context_;
    }

    public void buildParams(String sql, String dbname) throws SetSQLParamException {
        if (this.realParams != null) {
            return;
        }
        if (this.realParams == null) {
            SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
            if (this.pretoken.equals("#\\[") && this.endtoken.equals("\\]")) {
                this.buildParamsByVariableParser(sqlinfo, null, dbname, null);
            } else {
                this.buildParamsByRegex(sqlinfo, null, dbname);
            }
        }
    }

    public void buildParams(SQLInfo sql, String dbname) throws SetSQLParamException {
        this.buildParams(sql, dbname, (NewSQLInfo)null);
    }

    public void buildParams(SQLInfo sql, String dbname, NewSQLInfo firstnewsql) throws SetSQLParamException {
        if (this.realParams != null) {
            return;
        }
        if (this.realParams == null) {
            if (this.pretoken.equals("#\\[") && this.endtoken.equals("\\]")) {
                this.buildParamsByVariableParser(sql, null, dbname, firstnewsql);
            } else {
                this.buildParamsByRegex(sql, null, dbname);
            }
        }
    }

    public void buildParams(String sql, String totalsizesql, String dbname) throws SetSQLParamException {
        if (this.realParams != null) {
            return;
        }
        if (totalsizesql == null) {
            SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
            if (this.pretoken.equals("#\\[") && this.endtoken.equals("\\]")) {
                this.buildParamsByVariableParser(sqlinfo, null, dbname, null);
            } else {
                this.buildParamsByRegex(sqlinfo, null, dbname);
            }
        } else {
            SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
            SQLInfo totalsizesqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(totalsizesql, true, true);
            if (this.pretoken.equals("#\\[") && this.endtoken.equals("\\]")) {
                this.buildParamsByVariableParser(sqlinfo, totalsizesqlinfo, dbname, null);
            } else {
                this.buildParamsByRegex(sqlinfo, totalsizesqlinfo, dbname);
            }
        }
    }

    public void buildParams(SQLInfo sql, SQLInfo totalsizesql, String dbname) throws SetSQLParamException {
        if (this.realParams != null) {
            return;
        }
        if (this.pretoken.equals("#\\[") && this.endtoken.equals("\\]")) {
            this.buildParamsByVariableParser(sql, totalsizesql, dbname, null);
        } else {
            this.buildParamsByRegex(sql, totalsizesql, dbname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildParamsByRegex(SQLInfo sqlinfo, SQLInfo totalsizesqlinfo, String dbname) throws SetSQLParamException {
        String[] vars;
        String sql = null;
        String totalsizesql = null;
        ArrayList<Param> _realParams = new ArrayList<Param>();
        VelocityContext vcontext = null;
        if (sqlinfo.istpl()) {
            sqlinfo.getSqltpl().process();
            if (sqlinfo.istpl()) {
                vcontext = this.buildVelocityContext(this.sqlparams);
                BBossStringWriter sw = new BBossStringWriter();
                sqlinfo.getSqltpl().merge((Context)vcontext, (Writer)sw);
                sql = sw.toString();
            } else {
                sql = sqlinfo.getSql();
            }
        } else {
            sql = sqlinfo.getSql();
        }
        String[][] args = parserResults.get(sql);
        if (args == null) {
            Object object = lock;
            synchronized (object) {
                args = parserResults.get(sql);
                if (args == null) {
                    args = VariableHandler.parser2ndSubstitution((String)sql, (String)this.pretoken, (String)this.endtoken, (String)"?");
                    parserResults.put(sql, args);
                }
            }
        }
        this.newsql = new NewSQLInfo(args[0][0]);
        this.newsql.setOldsql(sqlinfo);
        if (totalsizesqlinfo != null) {
            if (totalsizesqlinfo.istpl()) {
                totalsizesqlinfo.getSqltpl().process();
                if (totalsizesqlinfo.istpl()) {
                    if (vcontext == null) {
                        vcontext = this.buildVelocityContext(this.sqlparams);
                    }
                    BBossStringWriter sw = new BBossStringWriter();
                    totalsizesqlinfo.getSqltpl().merge((Context)vcontext, (Writer)sw);
                    totalsizesql = sw.toString();
                } else {
                    totalsizesql = totalsizesqlinfo.getSql();
                }
            } else {
                totalsizesql = totalsizesqlinfo.getSql();
            }
            String[][] totalsizesqlargs = parserResults.get(totalsizesql);
            if (totalsizesqlargs == null) {
                Object object = lock;
                synchronized (object) {
                    totalsizesqlargs = parserResults.get(totalsizesql);
                    if (totalsizesqlargs == null) {
                        totalsizesqlargs = VariableHandler.parser2ndSubstitution((String)totalsizesql, (String)this.pretoken, (String)this.endtoken, (String)"?");
                        parserResults.put(totalsizesql, totalsizesqlargs);
                    }
                }
            }
            this.newsql.setNewtotalsizesql(totalsizesqlargs[0][0]);
            this.newsql.setOldtotalsizesql(totalsizesqlinfo);
        }
        if ((vars = args[1]).length == 0) {
            log.debug("\u9884\u7f16\u8bd1sql\u8bed\u53e5\u63d0\u793a\uff1a\u6307\u5b9a\u4e86\u9884\u7f16\u8bd1\u53c2\u6570,sql\u8bed\u53e5\u4e2d\u6ca1\u6709\u5305\u542b\u7b26\u5408\u8981\u6c42\u7684\u9884\u7f16\u8bd1\u53d8\u91cf\uff0c" + this);
        }
        Param temp = null;
        for (int i = 0; i < vars.length; ++i) {
            temp = this.sqlparams.get(vars[i]);
            if (temp == null) {
                throw new SetSQLParamException("\u672a\u6307\u5b9a\u7ed1\u5b9a\u53d8\u91cf\u7684\u503c\uff1a" + vars[i] + "\r\n" + this);
            }
            Param newparam = temp.clone();
            newparam.index = i + 1;
            _realParams.add(newparam);
        }
        this.realParams = new Params(_realParams);
    }

    private void buildParamsByVariableParser(SQLInfo sqlinfo, SQLInfo totalsizesqlinfo, String dbname, NewSQLInfo firstnewsql) throws SetSQLParamException {
        JDBCPool pool;
        String sql = null;
        String totalsizesql = null;
        ArrayList<Param> _realParams = new ArrayList<Param>();
        VariableHandler.SQLStruction sqlstruction = null;
        VelocityContext vcontext = null;
        if (firstnewsql == null) {
            BBossStringWriter sw;
            if (sqlinfo.istpl()) {
                sqlinfo.getSqltpl().process();
                if (sqlinfo.istpl()) {
                    vcontext = this.buildVelocityContext(this.sqlparams);
                    sw = new BBossStringWriter();
                    sqlinfo.getSqltpl().merge((Context)vcontext, (Writer)sw);
                    sql = sw.toString();
                } else {
                    sql = sqlinfo.getSql();
                }
            } else {
                sql = sqlinfo.getSql();
            }
            sqlstruction = sqlinfo.getSqlutil() == null ? SQLUtil.getGlobalSQLUtil().getSQLStruction(sqlinfo, sql) : sqlinfo.getSqlutil().getSQLStruction(sqlinfo, sql);
            this.newsql = new NewSQLInfo(sqlstruction.getSql());
            this.newsql.setOldsql(sqlinfo);
            this.newsql.setSqlstruction(sqlstruction);
            if (totalsizesqlinfo != null) {
                if (totalsizesqlinfo.istpl()) {
                    totalsizesqlinfo.getSqltpl().process();
                    if (totalsizesqlinfo.istpl()) {
                        if (vcontext == null) {
                            vcontext = this.buildVelocityContext(this.sqlparams);
                        }
                        sw = new BBossStringWriter();
                        totalsizesqlinfo.getSqltpl().merge((Context)vcontext, (Writer)sw);
                        totalsizesql = sw.toString();
                    } else {
                        totalsizesql = totalsizesqlinfo.getSql();
                    }
                } else {
                    totalsizesql = totalsizesqlinfo.getSql();
                }
                VariableHandler.SQLStruction totalsizesqlstruction = null;
                totalsizesqlstruction = totalsizesqlinfo.getSqlutil() == null ? SQLUtil.getGlobalSQLUtil().getTotalsizeSQLStruction(totalsizesqlinfo, totalsizesql) : totalsizesqlinfo.getSqlutil().getTotalsizeSQLStruction(totalsizesqlinfo, totalsizesql);
                this.newsql.setOldtotalsizesql(totalsizesqlinfo);
                String newtotalsizesql = totalsizesqlstruction.getSql();
                this.newsql.setNewtotalsizesql(newtotalsizesql);
            }
        } else {
            this.newsql = firstnewsql;
            sqlstruction = this.newsql.getSqlstruction();
        }
        if (sqlstruction.hasVars()) {
            Param temp = null;
            List vars = sqlstruction.getVariables();
            for (int i = 0; i < vars.size(); ++i) {
                VariableHandler.Variable var = (VariableHandler.Variable)vars.get(i);
                temp = this.sqlparams.get(var.getVariableName());
                if (temp == null) {
                    throw new SetSQLParamException("\u672a\u6307\u5b9a\u7ed1\u5b9a\u53d8\u91cf\u7684\u503c\uff1a" + var.getVariableName() + "\r\n" + this.toString());
                }
                Param newparam = temp.clone(var);
                newparam.index = i + 1;
                _realParams.add(newparam);
            }
        }
        this.realParams = new Params(_realParams);
        if (this.pagineOrderby != null) {
            String _pagineOrderby = null;
            if (!this.pagineOrderby.isPlain()) {
                SQLInfo conditionsqlinfo = null;
                conditionsqlinfo = this.pagineOrderby.isConfig() ? sqlinfo.getSQLInfo(dbname, this.pagineOrderby.getPagineOrderby()) : SQLUtil.getGlobalSQLUtil().getSQLInfo(this.pagineOrderby.getPagineOrderby(), true, true);
                if (conditionsqlinfo == null) {
                    throw new SetSQLParamException(this.pagineOrderby.toString(":\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684ROW_NUMBER () OVER() order by \u6761\u4ef6\u8bed\u53e5\u3002"));
                }
                if (conditionsqlinfo.istpl()) {
                    conditionsqlinfo.getSqltpl().process();
                    if (conditionsqlinfo.istpl()) {
                        if (vcontext == null) {
                            vcontext = this.buildVelocityContext(this.sqlparams);
                        }
                        BBossStringWriter sw = new BBossStringWriter();
                        conditionsqlinfo.getSqltpl().merge((Context)vcontext, (Writer)sw);
                        _pagineOrderby = sw.toString();
                    } else {
                        _pagineOrderby = conditionsqlinfo.getSql();
                    }
                } else {
                    _pagineOrderby = conditionsqlinfo.getSql();
                }
            } else {
                _pagineOrderby = this.pagineOrderby.isConfig() ? sqlinfo.getPlainSQL(dbname, this.pagineOrderby.getPagineOrderby()) : this.pagineOrderby.getPagineOrderby();
            }
            this.realParams.setPagineOrderby(_pagineOrderby.trim());
        }
        if (sqlstruction.hasVars() && (pool = SQLManager.getInstance().getPool(dbname)) != null && pool.showsqlParams() && log.isInfoEnabled()) {
            log.info("SQL INFO:" + this.toString());
        }
    }

    public String getPretoken() {
        return this.pretoken;
    }

    public void setPretoken(String pretoken) {
        if (pretoken != null && !pretoken.equals("")) {
            this.pretoken = pretoken;
        }
    }

    public String getEndtoken() {
        return this.endtoken;
    }

    public void setEndtoken(String endtoken) {
        if (endtoken != null && !endtoken.equals("")) {
            this.endtoken = endtoken;
        }
    }

    public Map<String, Param> getParams() {
        return this.sqlparams;
    }

    public void addSQLParam(String name, Object value, String type) throws SetSQLParamException {
        this.addSQLParam(name, value, -100L, type, null, null);
    }

    public void addSQLParamWithCharset(String name, Object value, String type, String charset) throws SetSQLParamException {
        this.addSQLParam(name, value, -100L, type, null, charset);
    }

    public void addSQLParam(String name, Object value, long size, String type) throws SetSQLParamException {
        this.addSQLParam(name, value, size, type, null, null);
    }

    public static Object handleDate(Object value) {
        if (value == null || value instanceof Timestamp) {
            return value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        return value;
    }

    public static String getParamJavaType(String fieldName, Class clazz) throws NestedSQLException {
        if (String.class.isAssignableFrom(clazz)) {
            return STRING;
        }
        if (Integer.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz)) {
            return INT;
        }
        if (Long.TYPE.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz)) {
            return LONG;
        }
        if (Double.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz)) {
            return DOUBLE;
        }
        if (Float.TYPE.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz)) {
            return FLOAT;
        }
        if (Short.TYPE.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz)) {
            return SHORT;
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return TIMESTAMP;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DATE;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return TIMESTAMP;
        }
        if (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
            return BOOLEAN;
        }
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            return BYTE;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return TIME;
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            return BYTEARRAY;
        }
        if (blobbyte[].class.isAssignableFrom(clazz)) {
            return BLOBBYTEARRAY;
        }
        if (blobfile.class.isAssignableFrom(clazz)) {
            return BLOBFILE;
        }
        if (clobfile.class.isAssignableFrom(clazz)) {
            return CLOBFILE;
        }
        if (Clob.class.isAssignableFrom(clazz)) {
            return CLOB;
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return BLOB;
        }
        if (BigFile.class.isAssignableFrom(clazz)) {
            log.warn("\u5c5e\u6027[" + fieldName + "]\u6570\u636e\u7c7b\u578b\u4e3a\uff1a" + clazz.getCanonicalName() + ",\u5fc5\u987b\u901a\u8fc7@Column\u6ce8\u89e3\u6765\u6307\u5b9a\u5b57\u6bb5\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u7c7b\u578b\u4e3ablobfile\u6216\u8005clobfile,\u4f8b\u5982\uff1a@Column(type=\"blobfile\")");
            return OBJECT;
        }
        return OBJECT;
    }

    public static List<SQLParams> convertBeansToSqlParams(List beans, SQLInfo sql, String dbname, int action, Connection con) throws SQLException {
        if (beans == null) {
            return null;
        }
        ArrayList<SQLParams> batchparams = new ArrayList<SQLParams>(beans.size());
        for (Object bean : beans) {
            SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, action, con);
            batchparams.add(params);
        }
        return batchparams;
    }

    public static List<SQLParams> convertBeansToSqlParams(List beans, SQLInfo sql, String dbname, int action, Connection con, int start, int end, int step) throws SQLException {
        if (beans == null) {
            return null;
        }
        ArrayList<SQLParams> batchparams = new ArrayList<SQLParams>(step);
        for (int i = start; i < end; ++i) {
            Object bean = beans.get(i);
            SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, action, con);
            batchparams.add(params);
        }
        return batchparams;
    }

    public static SQLParams convertMaptoSqlParams(Map<String, Object> bean, SQLInfo sql) throws SetSQLParamException {
        if (bean == null || bean.size() == 0) {
            SQLParams temp = new SQLParams();
            temp.setFrommap(true);
            temp.setOldsql(sql);
            return temp;
        }
        SQLParams temp = new SQLParams();
        temp.setFrommap(true);
        temp.setOldsql(sql);
        for (Map.Entry<String, Object> entrie : bean.entrySet()) {
            temp.addSQLParam(entrie.getKey(), entrie.getValue(), OBJECT);
        }
        return temp;
    }

    public static SQLParams convertBeanToSqlParams(Object bean, SQLInfo sql, String dbname, int action, Connection con) throws SQLException {
        PagineOrderby pagineOrderby = null;
        if (bean == null) {
            SQLParams temp = new SQLParams();
            temp.setFrommap(true);
            temp.setOldsql(sql);
            return temp;
        }
        if (bean instanceof SQLParams) {
            SQLParams temp = (SQLParams)bean;
            if (temp.getOldsql() == null) {
                temp.setOldsql(sql);
            }
            return temp;
        }
        if (bean instanceof Map) {
            SQLParams temp = SQLParams.convertMaptoSqlParams((Map)bean, sql);
            return temp;
        }
        if (action == 3 && bean instanceof PagineOrderby) {
            pagineOrderby = (PagineOrderby)bean;
            Object condition = pagineOrderby.getConditionBean();
            if (condition == null) {
                SQLParams temp = new SQLParams();
                temp.setFrommap(true);
                temp.setOldsql(sql);
                temp.setPagineOrderby(pagineOrderby);
                return temp;
            }
            if (condition instanceof SQLParams) {
                SQLParams temp = (SQLParams)condition;
                if (temp.getOldsql() == null) {
                    temp.setOldsql(sql);
                }
                temp.setPagineOrderby(pagineOrderby);
                return temp;
            }
            if (condition instanceof Map) {
                SQLParams temp = SQLParams.convertMaptoSqlParams((Map)condition, sql);
                temp.setPagineOrderby(pagineOrderby);
                return temp;
            }
            bean = pagineOrderby.getConditionBean();
        }
        SQLParams params = new SQLParams();
        if (pagineOrderby != null) {
            params.setPagineOrderby(pagineOrderby);
        }
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(bean.getClass());
        params.setOldsql(sql);
        String name = null;
        DateFormateMeta dataformat = null;
        String charset = null;
        Object value = null;
        Class type = null;
        String sqltype = null;
        List attributes = beanInfo.getPropertyDescriptors();
        for (int i = 0; attributes != null && i < attributes.size(); ++i) {
            ClassUtil.PropertieDescription property = (ClassUtil.PropertieDescription)attributes.get(i);
            ColumnWraper column = property.getColumn();
            if (column != null && (column.ignoreCUDbind() || column.ignorebind())) continue;
            type = property.getPropertyType();
            try {
                if (property.canread()) {
                    try {
                        value = property.getValue(bean);
                    }
                    catch (InvocationTargetException e1) {
                        log.error("\u83b7\u53d6\u5c5e\u6027[" + beanInfo.getClazz().getName() + "." + property.getName() + "]\u503c\u5931\u8d25\uff1a", e1.getTargetException());
                    }
                    catch (Exception e1) {
                        log.error("\u83b7\u53d6\u5c5e\u6027[" + beanInfo.getClazz().getName() + "." + property.getName() + "]\u503c\u5931\u8d25\uff1a", (Throwable)e1);
                    }
                    name = property.getName();
                    PrimaryKey pka = property.getPk();
                    if (pka != null && pka.auto() && action == 0) {
                        String pkname = pka.pkname();
                        if (StringUtil.isNotEmpty((String)pkname)) {
                            if (type == Long.TYPE || type == Integer.TYPE || type == Long.class || type == Integer.class) {
                                long _value = DBUtil.getNextPrimaryKey(con, dbname, pkname);
                                value = type == Integer.TYPE ? (Number)((int)_value) : (Number)(type == Integer.class ? (Number)new Integer((int)_value) : (Number)(type == Long.class ? new Long(_value) : Long.valueOf(_value)));
                            } else {
                                value = DBUtil.getNextStringPrimaryKey(con, dbname, pkname);
                            }
                        } else {
                            IdGenerator idGenerator = SQLManager.getInstance().getPool(dbname).getIdGenerator();
                            value = idGenerator.getNextId(pka, dbname, type, name);
                        }
                        if (!property.canwrite()) continue;
                        property.setValue(bean, value);
                    }
                    if (column != null) {
                        ColumnEditorInf editor = column.editor();
                        if (editor == null || editor instanceof ColumnToFieldEditor) {
                            dataformat = column.getDateFormateMeta();
                            charset = column.charset();
                            String type_ = column.type();
                            if (type_ != null) {
                                if (type_.equals(CLOB)) {
                                    type = Clob.class;
                                } else if (type_.equals(BLOB)) {
                                    type = Blob.class;
                                } else if (type_.equals(BLOBFILE)) {
                                    type = blobfile.class;
                                } else if (type_.equals(CLOBFILE)) {
                                    type = clobfile.class;
                                } else if (type_.equals(BLOBBYTEARRAY)) {
                                    type = blobbyte[].class;
                                }
                            }
                        } else {
                            Object cv = editor.toColumnValue(column, value);
                            if (cv == null) {
                                throw new NestedSQLException("\u8f6c\u6362\u5c5e\u6027[" + beanInfo.getClazz().getName() + "." + property.getName() + "]\u503c\u5931\u8d25\uff1a\u503c\u4e3anull\u65f6\uff0c\u8f6c\u6362\u5668\u5fc5\u987b\u8fd4\u56deColumnType\u7c7b\u578b\u7684\u5bf9\u8c61,\u7528\u6765\u6307\u793a\u8868\u5b57\u6bb5\u5bf9\u5e94\u7684java\u7c7b\u578b\u3002");
                            }
                            if (!(cv instanceof ColumnType)) {
                                value = cv;
                                type = value.getClass();
                            } else {
                                type = ((ColumnType)cv).getType();
                            }
                        }
                    }
                    sqltype = SQLParams.getParamJavaType(name, type);
                    params.addSQLParamWithDateFormateMeta(name, value, sqltype, dataformat, charset);
                }
                name = null;
                value = null;
                sqltype = null;
                dataformat = null;
                charset = null;
                continue;
            }
            catch (SecurityException e) {
                throw new NestedSQLException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new NestedSQLException((Throwable)e);
            }
            catch (Exception e) {
                throw new NestedSQLException((Throwable)e);
            }
        }
        return params;
    }

    private Object handleData(String name, Object value, String type, String dataformat) throws SetSQLParamException {
        if (dataformat == null || dataformat.equals("")) {
            return this.handleDataWithDateFormateMeta(name, value, type, null);
        }
        DateFormateMeta dd = DateFormateMeta.buildDateFormateMeta((String)dataformat, null);
        return this.handleDataWithDateFormateMeta(name, value, type, dd);
    }

    private Object handleDataWithDateFormateMeta(String name, Object value, String type, DateFormateMeta dataformat) throws SetSQLParamException {
        if (type.equals(STRING)) {
            if (value instanceof String) {
                return value;
            }
            return String.valueOf(value);
        }
        if (type.equals(INT)) {
            if (value instanceof Integer) {
                return value;
            }
            return Integer.parseInt(value.toString());
        }
        if (type.equals(LONG)) {
            if (value instanceof Long) {
                return value;
            }
            return Long.parseLong(value.toString());
        }
        if (type.equals(DOUBLE)) {
            if (value instanceof Double) {
                return value;
            }
            return Double.parseDouble(value.toString());
        }
        if (type.equals(FLOAT)) {
            if (value instanceof Float) {
                return value;
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (type.equals(SHORT)) {
            if (value instanceof Short) {
                return value;
            }
            return Short.parseShort(value.toString());
        }
        if (type.equals(DATE)) {
            if (value instanceof Timestamp) {
                return value;
            }
            if (value instanceof Date) {
                return new Timestamp(((Date)value).getTime());
            }
            if (value instanceof java.util.Date) {
                return new Timestamp(((java.util.Date)value).getTime());
            }
            try {
                return PreparedDBUtil.getDBAdapter(this.dbname).getDate(value.toString(), dataformat);
            }
            catch (Exception e) {
                throw new SetSQLParamException("\u975e\u6cd5\u7ed1\u5b9a\u53d8\u91cf\u7684\u503c\u6216\u683c\u5f0f\uff1aname=" + name + ",value=" + value + ",type=" + type + ",dataformat=" + dataformat, e);
            }
        }
        if (type.equals(TIMESTAMP)) {
            if (value instanceof Timestamp) {
                return value;
            }
            if (value instanceof Date) {
                return new Timestamp(((Date)value).getTime());
            }
            if (value instanceof java.util.Date) {
                return new Timestamp(((java.util.Date)value).getTime());
            }
            try {
                return PreparedDBUtil.getDBAdapter(this.dbname).getTimestamp(value.toString(), dataformat);
            }
            catch (Exception e) {
                throw new SetSQLParamException("\u975e\u6cd5\u7ed1\u5b9a\u53d8\u91cf\u7684\u503c\u6216\u683c\u5f0f\uff1aname" + "=" + name + ",value" + "=" + value + ",type" + "=" + type + ",dataformat" + "=" + dataformat, e);
            }
        }
        if (type.equals(BIGDECIMAL)) {
            if (value instanceof Long) {
                return value;
            }
            return Long.parseLong(value.toString());
        }
        if (type.equals(BOOLEAN)) {
            if (value instanceof Boolean) {
                return value;
            }
            return Boolean.parseBoolean(value.toString());
        }
        if (type.equals(BYTE)) {
            if (value instanceof Byte) {
                return value;
            }
            return Byte.parseByte(value.toString());
        }
        if (type.equals(TIME)) {
            if (value instanceof Time) {
                return value;
            }
            return Time.valueOf(value.toString());
        }
        if (type.equals(BYTEARRAY)) {
            if (value instanceof byte[]) {
                return value;
            }
            return value.toString().getBytes();
        }
        if (type.equals(BLOBBYTEARRAY)) {
            if (value instanceof byte[]) {
                return value;
            }
            return value.toString().getBytes();
        }
        if (type.equals(BLOBFILE)) {
            if (value instanceof File) {
                return value;
            }
            if (value instanceof InputStream) {
                return value;
            }
            if (value instanceof BigFile) {
                return value;
            }
            return new File(value.toString());
        }
        if (type.equals(CLOBFILE)) {
            if (value instanceof File) {
                return value;
            }
            if (value instanceof InputStream) {
                return value;
            }
            if (value instanceof BigFile) {
                return value;
            }
            return new File(value.toString());
        }
        if (type.equals(OBJECT)) {
            return SQLParams.handleDate(value);
        }
        return value;
    }

    public static void main(String[] args) {
        System.out.println(Time.valueOf("10:10:10"));
    }

    public void addSQLParam(String name, Object value, String type, String dataformat) throws SetSQLParamException {
        this.addSQLParam(name, value, -100L, type, dataformat, null);
    }

    public void addSQLParam(String name, Object value, String type, String dataformat, String charset) throws SetSQLParamException {
        this.addSQLParam(name, value, -100L, type, dataformat, charset);
    }

    public void addSQLParamWithDateFormateMeta(String name, Object value, String type, DateFormateMeta dataformat, String charset) throws SetSQLParamException {
        this.addSQLParamWithDateFormateMeta(name, value, -100L, type, dataformat, charset);
    }

    public void addSQLParam(String name, Object value, long size, String type, String dataformat) throws SetSQLParamException {
        this.addSQLParam(name, value, size, type, dataformat, null);
    }

    public void addSQLParamWithDateFormateMeta(String name, Object value, long size, String type, DateFormateMeta dataformat, String charset) throws SetSQLParamException {
        if (this.sqlparams == null) {
            this.sqlparams = new HashMap<String, Param>();
        }
        Param param = new Param();
        Object data_ = null;
        if (type == null) {
            type = STRING;
        }
        type = type.toLowerCase();
        if (value == null) {
            if (!type.equals(OBJECT)) {
                data_ = new Integer(this.converttypeToSqltype(type));
                type = NULL;
            }
        } else {
            data_ = this.handleDataWithDateFormateMeta(name, value, type, dataformat);
            if (type.equals(DATE)) {
                type = TIMESTAMP;
            }
        }
        param.setName(name);
        if (size < 0L) {
            param.setData(data_);
        } else {
            param.setData(new Object[]{data_, size});
        }
        param.setType(type);
        param.setCharset(charset);
        BaseTypeMethod method = SQLParams.converttypeToMethod(type);
        param.setMethod(method);
        if (dataformat != null) {
            param.setDataformat(dataformat.getDateformat());
        }
        this.sqlparams.put(param.getName(), param);
    }

    public void addSQLParam(String name, Object value, long size, String type, String dataformat, String charset) throws SetSQLParamException {
        if (this.sqlparams == null) {
            this.sqlparams = new HashMap<String, Param>();
        }
        Param param = new Param();
        Object data_ = null;
        if (type == null) {
            type = STRING;
        }
        type = type.toLowerCase();
        if (value == null) {
            if (!type.equals(OBJECT)) {
                data_ = new Integer(this.converttypeToSqltype(type));
                type = NULL;
            }
        } else {
            data_ = this.handleData(name, value, type, dataformat);
            if (type.equals(DATE)) {
                type = TIMESTAMP;
            }
        }
        param.setName(name);
        if (size < 0L) {
            param.setData(data_);
        } else {
            param.setData(new Object[]{data_, size});
        }
        param.setType(type);
        param.setCharset(charset);
        BaseTypeMethod method = SQLParams.converttypeToMethod(type);
        param.setMethod(method);
        param.setDataformat(dataformat);
        this.sqlparams.put(param.getName(), param);
    }

    public static BaseTypeMethod converttypeToMethod(String type) {
        return SQLParams.converttypeToMethod(type, true);
    }

    public static BaseTypeMethod converttypeToMethod(String type, boolean useDefualt) {
        if (type == null || type.equals("")) {
            return null;
        }
        if (type.equals(STRING)) {
            return Param.setString_int_String;
        }
        if (type.equals(INT)) {
            return Param.setInt_int_int;
        }
        if (type.equals(LONG)) {
            return Param.setLong_int_long;
        }
        if (type.equals(FLOAT)) {
            return Param.setFloat_int_float;
        }
        if (type.equals(DOUBLE)) {
            return Param.setDouble_int_double;
        }
        if (type.equals(SHORT)) {
            return Param.setShort_int_short;
        }
        if (type.equals(DATE)) {
            return Param.setDate_int_sqlDate;
        }
        if (type.equals(TIME)) {
            return Param.setTime_int_Time;
        }
        if (type.equals(TIMESTAMP)) {
            return Param.setTimestamp_int_Timestamp;
        }
        if (type.equals(BLOBFILE)) {
            return Param.setBlob_int_File;
        }
        if (type.equals(CLOBFILE)) {
            return Param.setClob_int_File;
        }
        if (type.equals(CLOB)) {
            return Param.setClob_int_String;
        }
        if (type.equals(BLOB)) {
            return Param.setBlob_int_blob;
        }
        if (type.equals(BYTE)) {
            return Param.setByte_int_byte;
        }
        if (type.equals(BYTEARRAY)) {
            return Param.setBytes_int_bytearray;
        }
        if (type.equals(BLOBBYTEARRAY)) {
            return Param.setBlob_int_bytearray;
        }
        if (type.equals(BOOLEAN)) {
            return Param.setBoolean_int_boolean;
        }
        if (type.equals(BIGDECIMAL)) {
            return Param.SET_BigDecimal_INT_BigDecimal;
        }
        if (type.equals(NULL)) {
            return Param.setNull_int_int;
        }
        return Param.setObject_int_Object;
    }

    public int converttypeToSqltype(String type) {
        if (type.equals(STRING)) {
            return 12;
        }
        if (type.equals(INT)) {
            return 4;
        }
        if (type.equals(DOUBLE)) {
            return 8;
        }
        if (type.equals(FLOAT)) {
            return 6;
        }
        if (type.equals(LONG)) {
            return -5;
        }
        if (type.equals(SHORT)) {
            return 5;
        }
        if (type.equals(DATE)) {
            return 91;
        }
        if (type.equals(TIME)) {
            return 92;
        }
        if (type.equals(TIMESTAMP)) {
            return 93;
        }
        if (type.equals(BYTEARRAY)) {
            return -3;
        }
        if (type.equals(BLOBBYTEARRAY)) {
            return 2004;
        }
        if (type.equals(BYTE)) {
            return -7;
        }
        if (type.equals(BOOLEAN)) {
            return 16;
        }
        if (type.equals(BIGDECIMAL)) {
            return -5;
        }
        if (type.equals(OBJECT)) {
            return 1111;
        }
        return 1111;
    }

    public int size() {
        return this.sqlparams != null ? this.sqlparams.size() : 0;
    }

    public SQLInfo getOldsql() {
        return this.oldsql;
    }

    public void setOldsql(String oldsql) {
        this.oldsql = SQLUtil.getGlobalSQLUtil().getSQLInfo(oldsql, true, true);
    }

    public void setOldsql(SQLInfo oldsql) {
        this.oldsql = oldsql;
    }

    public SQLParams copy() {
        SQLParams sqlparams = new SQLParams();
        sqlparams.action = this.action;
        sqlparams.dbname = this.dbname;
        sqlparams.endtoken = this.endtoken;
        sqlparams.newsql = this.newsql;
        sqlparams.oldsql = this.oldsql;
        sqlparams.pretoken = this.pretoken;
        if (this.realParams != null) {
            sqlparams.realParams = this.realParams.copy();
        }
        sqlparams.sqlparams = this.sqlparams;
        return sqlparams;
    }

    public boolean isFrommap() {
        return this.frommap;
    }

    public void setFrommap(boolean frommap) {
        this.frommap = frommap;
    }

    public static final class clobfile {
        private File data;

        public clobfile(File data) {
            this.data = data;
        }

        public File getData() {
            return this.data;
        }
    }

    public static final class blobfile {
        private File data;

        public blobfile(File data) {
            this.data = data;
        }

        public File getData() {
            return this.data;
        }
    }

    public static final class blobbyte {
        byte data;

        public blobbyte(byte data) {
            this.data = data;
        }

        public byte getData() {
            return this.data;
        }
    }
}

