/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.transaction;

import com.frameworkset.orm.annotation.TransactionType;
import com.frameworkset.orm.transaction.JDBCTransaction;
import com.frameworkset.orm.transaction.TransactionException;
import java.io.Serializable;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TransactionManager.class);
    static final ThreadLocal thread_local = new ThreadLocal();
    private boolean started = false;
    private boolean committed = false;
    private boolean rollbacked = false;
    private JDBCTransaction context_tx = null;
    private JDBCTransaction suspend_tx = null;
    public static final TransactionType NEW_TRANSACTION = TransactionType.NEW_TRANSACTION;
    public static final TransactionType REQUIRED_TRANSACTION = TransactionType.REQUIRED_TRANSACTION;
    public static final TransactionType MAYBE_TRANSACTION = TransactionType.MAYBE_TRANSACTION;
    public static final TransactionType NO_TRANSACTION = TransactionType.NO_TRANSACTION;
    public static final TransactionType RW_TRANSACTION = TransactionType.RW_TRANSACTION;
    public static final TransactionType UNKNOWN_TRANSACTION = TransactionType.UNKNOWN_TRANSACTION;
    private TransactionType currenttxtype = TransactionType.REQUIRED_TRANSACTION;
    private static final long serialVersionUID = -6716097342564237376L;

    public void begin() throws TransactionException {
        this.begin(REQUIRED_TRANSACTION);
    }

    public void begin(TransactionType tx_type) throws TransactionException {
        if (this.committed) {
            throw new TransactionException("\u4e8b\u52a1\u5df2\u7ecf\u63d0\u4ea4");
        }
        if (this.rollbacked) {
            throw new TransactionException("\u4e8b\u52a1\u5df2\u7ecf\u56de\u6eda");
        }
        if (this.started) {
            throw new TransactionException("\u4e8b\u52a1\u5df2\u7ecf\u542f\u52a8\uff0c\u5e76\u4e14\u4e8b\u52a1\u6b63\u5728\u6267\u884c\u4e2d\u3002");
        }
        JDBCTransaction currentTx = (JDBCTransaction)thread_local.get();
        this.currenttxtype = tx_type;
        switch (tx_type) {
            case NEW_TRANSACTION: {
                if (currentTx == null) {
                    JDBCTransaction newTx = new JDBCTransaction(NEW_TRANSACTION);
                    thread_local.set(newTx);
                    newTx.begin();
                    break;
                }
                this.context_tx = currentTx;
                JDBCTransaction newTx = new JDBCTransaction(currentTx, NEW_TRANSACTION);
                newTx.begin();
                thread_local.set(newTx);
                break;
            }
            case RW_TRANSACTION: {
                if (currentTx != null) {
                    if (currentTx.getTXType() == RW_TRANSACTION) {
                        currentTx.begin();
                        break;
                    }
                    throw new TransactionException("\u5f53\u524d\u5b58\u5728\u7c7b\u578b\u4e3a[" + currentTx.getTXType() + "]\u7684\u4e8b\u52a1\uff0c\u4e0eRW_TRANSACTION\u7c7b\u578b\u4e8b\u52a1\u4e0d\u517c\u5bb9\uff0c\u65e0\u6cd5\u521b\u5efaRW_TRANSACTION\u7c7b\u578b\u4e8b\u52a1\u3002");
                }
                currentTx = new JDBCTransaction(RW_TRANSACTION);
                thread_local.set(currentTx);
                currentTx.begin();
                break;
            }
            case MAYBE_TRANSACTION: {
                if (currentTx == null) break;
                currentTx.begin();
                break;
            }
            case REQUIRED_TRANSACTION: {
                if (currentTx != null) {
                    if (currentTx.getTXType() != RW_TRANSACTION) {
                        currentTx.begin();
                        break;
                    }
                    throw new TransactionException("\u5f53\u524d\u5b58\u5728\u7c7b\u578b\u4e3a[" + currentTx.getTXType() + "]\u7684\u4e8b\u52a1\uff0c\u4e0eREQUIRED_TRANSACTION\u7c7b\u578b\u4e8b\u52a1\u4e0d\u517c\u5bb9\uff0c\u65e0\u6cd5\u521b\u5efaREQUIRED_TRANSACTION\u7c7b\u578b\u4e8b\u52a1\u3002");
                }
                currentTx = new JDBCTransaction(REQUIRED_TRANSACTION);
                thread_local.set(currentTx);
                currentTx.begin();
                break;
            }
            case NO_TRANSACTION: {
                try {
                    this.suspend_tx = this.suspendAll();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        this.started = true;
    }

    private void assertTX() throws RollbackException {
        if (!this.started) {
            throw new RollbackException("\u4e8b\u52a1\u6ca1\u6709\u5f00\u59cb");
        }
        if (this.committed) {
            throw new RollbackException("\u4e8b\u52a1\u5df2\u7ecf\u63d0\u4ea4");
        }
        if (this.rollbacked) {
            throw new RollbackException("\u4e8b\u52a1\u5df2\u7ecf\u56de\u6eda");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException {
        this.assertTX();
        JDBCTransaction tx = TransactionManager.getTransaction();
        try {
            if (this.currenttxtype == NO_TRANSACTION) {
                try {
                    this.resume(this.suspend_tx);
                }
                catch (InvalidTransactionException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalStateException e1) {
                    e1.printStackTrace();
                }
                catch (SystemException e1) {
                    e1.printStackTrace();
                }
                this.committed = true;
                return;
            }
            if (tx == null) {
                if (this.currenttxtype == MAYBE_TRANSACTION) {
                    this.committed = true;
                    return;
                }
                throw new IllegalStateException("thread not associated with transaction");
            }
        }
        finally {
            if (tx != null && tx.wasCommitted()) {
                if (this.context_tx == null) {
                    this.setTransaction(null);
                } else {
                    this.setTransaction(this.context_tx);
                }
            }
            this.committed = true;
        }
    }

    public void rollback() throws RollbackException {
        this._rollback(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _rollback(boolean check) throws RollbackException {
        if (check) {
            this.assertTX();
        }
        if (this.currenttxtype == NO_TRANSACTION) {
            try {
                this.resume(this.suspend_tx);
            }
            catch (InvalidTransactionException e1) {
                e1.printStackTrace();
            }
            catch (IllegalStateException e1) {
                e1.printStackTrace();
            }
            catch (SystemException e1) {
                e1.printStackTrace();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.rollbacked = true;
            return;
        }
        JDBCTransaction tx = TransactionManager.getTransaction();
        if (tx == null) {
            if (this.currenttxtype == MAYBE_TRANSACTION) {
                this.rollbacked = true;
                return;
            }
            throw new IllegalStateException("no transaction associated with thread or tx has been commited or rollbacked.");
        }
        if (this.context_tx != null && this.context_tx == tx) {
            this.rollbacked = true;
            return;
        }
        try {
            tx.rollback();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.rollbacked = true;
            if (tx != null && tx.wasRolledBack()) {
                if (this.context_tx == null) {
                    this.setTransaction(null);
                } else {
                    this.setTransaction(this.context_tx);
                }
            }
        }
    }

    public int getStatus() {
        JDBCTransaction tx = TransactionManager.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    public static JDBCTransaction getTransaction() {
        JDBCTransaction tx = (JDBCTransaction)thread_local.get();
        return tx;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        throw new SystemException("not supported");
    }

    public JDBCTransaction suspend() throws SystemException {
        JDBCTransaction retval = TransactionManager.getTransaction();
        if (this.context_tx != null) {
            this.setTransaction(this.context_tx);
        } else {
            this.setTransaction(null);
        }
        return retval;
    }

    public JDBCTransaction suspendAll() throws SystemException {
        JDBCTransaction retval = TransactionManager.getTransaction();
        this.setTransaction(null);
        return retval;
    }

    public void resume(JDBCTransaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.setTransaction(tx);
    }

    protected void setTransaction(JDBCTransaction tx) {
        thread_local.set(tx);
    }

    public static boolean destroyTransaction() {
        JDBCTransaction tx = TransactionManager.getTransaction();
        if (tx != null) {
            tx.printStackTrace();
            try {
                tx.rollback();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            thread_local.set(null);
            return true;
        }
        return false;
    }

    public TransactionType getCurrenttxtype() {
        return this.currenttxtype;
    }

    public String getCurrenttxtypeName() {
        switch (this.currenttxtype) {
            case NEW_TRANSACTION: {
                return "NEW_TRANSACTION";
            }
            case REQUIRED_TRANSACTION: {
                return "REQUIRED_TRANSACTION";
            }
            case MAYBE_TRANSACTION: {
                return "MAYBE_TRANSACTION";
            }
            case NO_TRANSACTION: {
                return "NO_TRANSACTION";
            }
            case RW_TRANSACTION: {
                return "RW_TRANSACTION";
            }
        }
        return "UNKNOWN_TRANSACTION";
    }

    public void release() {
        if (!this.started) {
            return;
        }
        if (this.committed) {
            return;
        }
        if (this.rollbacked) {
            return;
        }
        try {
            log.debug("Warnning:Detected uncommit Transaction,force rollbacked this transaction by system.", (Throwable)new Exception());
            this._rollback(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void releasenolog() {
        if (!this.started) {
            return;
        }
        if (this.committed) {
            return;
        }
        if (this.rollbacked) {
            return;
        }
        try {
            this._rollback(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

