/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.sql;

import com.frameworkset.orm.sql.Token;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class SQLScanner {
    private static final String WHITE = "\f\r\t\n ";
    private static final String ALFA = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String NUMER = "0123456789";
    private static final String ALFANUM = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String SPECIAL = ";(),'";
    private static final char COMMENT_POUND = '#';
    private static final char COMMENT_SLASH = '/';
    private static final char COMMENT_STAR = '*';
    private static final char COMMENT_DASH = '-';
    private Reader in;
    private int chr;
    private String token;
    private List tokens;
    private int line;
    private int col;

    public SQLScanner() {
        this(null);
    }

    public SQLScanner(Reader input) {
        this.setInput(input);
    }

    public void setInput(Reader input) {
        this.in = input;
    }

    private void readChar() throws IOException {
        boolean wasLine = (char)this.chr == '\r';
        this.chr = this.in.read();
        System.out.println("readchar:" + (char)this.chr);
        if ((char)this.chr == '\n' || (char)this.chr == '\r' || (char)this.chr == '\f') {
            this.col = 0;
            if (!wasLine || (char)this.chr != '\n') {
                ++this.line;
            }
        } else {
            ++this.col;
        }
    }

    private void scanIdentifier() throws IOException {
        this.token = "";
        char c = (char)this.chr;
        while (this.chr != -1 && WHITE.indexOf(c) == -1 && SPECIAL.indexOf(c) == -1) {
            this.token = this.token + (char)this.chr;
            this.readChar();
            c = (char)this.chr;
        }
        int start = this.col - this.token.length();
        System.out.println("token:" + this.token);
        this.tokens.add(new Token(this.token, this.line, start));
    }

    private void scanNegativeIdentifier() throws IOException {
        this.token = "-";
        char c = (char)this.chr;
        while (this.chr != -1 && WHITE.indexOf(c) == -1 && SPECIAL.indexOf(c) == -1) {
            this.token = this.token + (char)this.chr;
            this.readChar();
            c = (char)this.chr;
        }
        int start = this.col - this.token.length();
        this.tokens.add(new Token(this.token, this.line, start));
    }

    public List scan() throws IOException {
        this.line = 1;
        this.col = 0;
        boolean inComment = false;
        boolean inCommentSlashStar = false;
        boolean inCommentDash = false;
        this.tokens = new ArrayList();
        this.readChar();
        while (this.chr != -1) {
            char c = (char)this.chr;
            System.out.println(c);
            boolean inNegative = false;
            if (c == '-') {
                this.readChar();
                if ((char)this.chr == '-') {
                    inCommentDash = true;
                } else {
                    inNegative = true;
                    c = (char)this.chr;
                }
            }
            if (inCommentDash) {
                if (c == '\n' || c == '\r') {
                    inCommentDash = false;
                }
                this.readChar();
                continue;
            }
            if (c == '#') {
                inComment = true;
                this.readChar();
                continue;
            }
            if (c == '/') {
                this.readChar();
                if ((char)this.chr != '*') continue;
                inCommentSlashStar = true;
                continue;
            }
            if (inComment || inCommentSlashStar) {
                if (c == '*') {
                    this.readChar();
                    if ((char)this.chr == '/') {
                        inCommentSlashStar = false;
                    }
                } else if (c == '\n' || c == '\r') {
                    inComment = false;
                }
                this.readChar();
                continue;
            }
            if (ALFANUM.indexOf(c) >= 0) {
                if (inNegative) {
                    this.scanNegativeIdentifier();
                    continue;
                }
                this.scanIdentifier();
                continue;
            }
            if (SPECIAL.indexOf(c) >= 0) {
                this.tokens.add(new Token("" + c, this.line, this.col));
                this.readChar();
                continue;
            }
            this.readChar();
        }
        return this.tokens;
    }

    public static void main(String[] args) {
        String sql = "select a.name,b.tile from aa a,bb b";
        ByteArrayInputStream in = new ByteArrayInputStream(sql.getBytes());
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        SQLScanner scan = new SQLScanner();
        scan.setInput(reader);
        try {
            List list = scan.scan();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

