/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.annotation;

public enum DbType {
    MYSQL("mysql", "`%s`", "%s LIKE CONCAT('%%',#{%s},'%%')", "MySql\u6570\u636e\u5e93"),
    MARIADB("mariadb", "`%s`", "%s LIKE CONCAT('%%',#{%s},'%%')", "MariaDB\u6570\u636e\u5e93"),
    ORACLE("oracle", null, "%s LIKE CONCAT(CONCAT('%%',#{%s}),'%%')", "Oracle\u6570\u636e\u5e93"),
    DB2("db2", null, "%s LIKE CONCAT(CONCAT('%%',#{%s}),'%%')", "DB2\u6570\u636e\u5e93"),
    H2("h2", null, "%s LIKE CONCAT('%%',#{%s},'%%')", "H2\u6570\u636e\u5e93"),
    HSQL("hsql", null, "%s LIKE CONCAT('%%',#{%s},'%%')", "HSQL\u6570\u636e\u5e93"),
    SQLITE("sqlite", "`%s`", "%s LIKE CONCAT('%%',#{%s},'%%')", "SQLite\u6570\u636e\u5e93"),
    POSTGRE_SQL("postgresql", "\"%s\"", "%s LIKE CONCAT('%%',#{%s},'%%')", "Postgre\u6570\u636e\u5e93"),
    SQL_SERVER2005("sqlserver2005", null, "%s LIKE '%%'+#{%s}+'%%'", "SQLServer2005\u6570\u636e\u5e93"),
    SQL_SERVER("sqlserver", null, "%s LIKE '%%'+#{%s}+'%%'", "SQLServer\u6570\u636e\u5e93"),
    OTHER("other", null, null, "\u5176\u4ed6\u6570\u636e\u5e93");

    private final String db;
    private final String quote;
    private final String like;
    private final String desc;

    private DbType(String db, String quote, String like, String desc) {
        this.db = db;
        this.quote = quote;
        this.like = like;
        this.desc = desc;
    }

    public static DbType getDbType(String dbType) {
        DbType[] dts;
        for (DbType dt : dts = DbType.values()) {
            if (!dt.getDb().equalsIgnoreCase(dbType)) continue;
            return dt;
        }
        return OTHER;
    }

    public String getDb() {
        return this.db;
    }

    public String getQuote() {
        return this.quote;
    }

    public String getLike() {
        return this.like;
    }

    public String getDesc() {
        return this.desc;
    }
}

