/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceValue;

public class ItemResourceValue
extends ResourceValue {
    private final boolean mIsFrameworkAttr;

    public ItemResourceValue(String name, boolean isFrameworkAttr, boolean isFrameworkStyle) {
        this(name, isFrameworkAttr, null, isFrameworkStyle, null);
    }

    public ItemResourceValue(String name, boolean isFrameworkAttr, boolean isFrameworkStyle, String libraryName) {
        this(name, isFrameworkAttr, null, isFrameworkStyle, libraryName);
    }

    public ItemResourceValue(String attributeName, boolean isFrameworkAttr, String value, boolean isFrameworkStyle) {
        this(attributeName, isFrameworkAttr, value, isFrameworkStyle, null);
    }

    public ItemResourceValue(String attributeName, boolean isFrameworkAttr, String value, boolean isFrameworkStyle, String libraryName) {
        super(null, attributeName, value, isFrameworkStyle, libraryName);
        this.mIsFrameworkAttr = isFrameworkAttr;
    }

    public boolean isFrameworkAttr() {
        return this.mIsFrameworkAttr;
    }

    @Override
    public String toString() {
        return super.toString() + " (mIsFrameworkAttr=" + this.mIsFrameworkAttr + ")";
    }

    Attribute getAttribute() {
        return new Attribute(this.getName(), this.mIsFrameworkAttr);
    }

    static ItemResourceValue fromResourceValue(ResourceValue res, boolean isFrameworkAttr, String libraryName) {
        assert (res.getResourceType() == null) : (Object)((Object)res.getResourceType()) + " is not null";
        return new ItemResourceValue(res.getName(), isFrameworkAttr, res.getValue(), res.isFramework(), libraryName);
    }

    static final class Attribute {
        String mName;
        boolean mIsFrameworkAttr;

        Attribute(String name, boolean isFrameworkAttr) {
            this.mName = name;
            this.mIsFrameworkAttr = isFrameworkAttr;
        }

        public int hashCode() {
            int booleanHash = this.mIsFrameworkAttr ? 1231 : 1237;
            return 31 * booleanHash + this.mName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Attribute) {
                Attribute attr = (Attribute)obj;
                return this.mIsFrameworkAttr == attr.mIsFrameworkAttr && this.mName.equals(attr.mName);
            }
            return false;
        }

        public String toString() {
            return this.mName + " (framework:" + this.mIsFrameworkAttr + ")";
        }
    }
}

