package com.aliyun.openservices.ons.api.transaction;

import com.aliyun.openservices.ons.api.Admin;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;


/**
 * 发送分布式事务消息
 */
public interface TransactionProducer extends Admin {
    /**
     * 启动服务
     */
    public void start();


    /**
     * 关闭服务
     */
    public void shutdown();


    public SendResult send(final Message message, //
                           final LocalTransactionExecuter executer, //
                           final Object arg);
}
