/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.sample;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.OssShipperConfig;
import com.aliyun.openservices.log.common.OssShipperCsvStorageDetail;
import com.aliyun.openservices.log.common.ShipperTask;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.response.GetShipperResponse;
import com.aliyun.openservices.log.response.GetShipperTasksResponse;
import java.util.ArrayList;

public class shipper_sample {
    public static void main(String[] args) throws LogException {
        String accessId = "";
        String accessKey = "";
        String project = "ali-cn-hangzhou-stg-sls-admin";
        String host = "cn-hangzhou-staging-intranet.sls.aliyuncs.com";
        String logStore = "logtail_alarm";
        Client client = new Client(host, accessId, accessKey);
        String ossShipper = "logtail-alarm-shipper";
        String ossBucket = "sls-test-oss-shipper";
        String ossPrefix = "logtailalarm";
        String roleArn = "acs:ram::1654218965343050:role/aliyunlogdefaultrole";
        String compressType = "none";
        String pathFormat = "%Y/%m/%d/%H";
        int bufferInterval = 300;
        int bufferSize = 10;
        OssShipperConfig ossConfig = new OssShipperConfig(ossBucket, ossPrefix, roleArn, bufferInterval, bufferSize, compressType, pathFormat, "csv");
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("__topic__");
        columns.add("alarm_count");
        columns.add("alarm_message");
        columns.add("alarm_type");
        columns.add("category");
        columns.add("project_name");
        OssShipperCsvStorageDetail detail = (OssShipperCsvStorageDetail)ossConfig.GetStorageDetail();
        detail.setDelimiter(",");
        detail.setmStorageColumns(columns);
        detail.setQuote("\"");
        detail.setNullIdentifier("");
        detail.setHeader(false);
        GetShipperResponse ossRes = client.GetShipperConfig(project, logStore, ossShipper);
        System.out.println(ossRes.GetConfig().GetShipperType());
        System.out.println(ossRes.GetConfig().GetJsonObj());
        int startTime = (int)((double)System.currentTimeMillis() / 1000.0 - 7200.0);
        int endTime = (int)((double)System.currentTimeMillis() / 1000.0);
        GetShipperTasksResponse taskRes = client.GetShipperTasks(project, logStore, "logtail_alarm_offline", startTime, endTime, "", 0, 10);
        System.out.println(taskRes.GetTotalTask());
        for (ShipperTask shipperTask : taskRes.GetShipperTasks()) {
            System.out.println(shipperTask.GetTaskCreateTime());
            System.out.println(shipperTask.GetTaskFinishTime());
            System.out.println(shipperTask.GetTaskDataLines());
        }
    }
}

