/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.IndexKey;
import com.aliyun.openservices.log.exception.LogException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class IndexKeys {
    private Map<String, IndexKey> keys = new HashMap<String, IndexKey>();

    public IndexKeys() {
    }

    public IndexKeys(IndexKeys other) {
        this.keys = new HashMap<String, IndexKey>();
        for (Map.Entry<String, IndexKey> entry : other.GetKeys().entrySet()) {
            this.keys.put(entry.getKey(), new IndexKey(entry.getValue()));
        }
    }

    public Map<String, IndexKey> GetKeys() {
        return this.keys;
    }

    public void AddKey(String key, IndexKey keyContent) {
        this.keys.put(key, keyContent);
    }

    public JSONObject ToRequestJson() throws LogException {
        JSONObject keysDict = new JSONObject();
        for (Map.Entry<String, IndexKey> entry : this.keys.entrySet()) {
            keysDict.put((Object)entry.getKey(), (Object)entry.getValue().ToRequestJson());
        }
        return keysDict;
    }

    public String ToRequestString() throws LogException {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() throws LogException {
        JSONObject keysDict = this.ToRequestJson();
        return keysDict;
    }

    public String ToJsonString() throws LogException {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            this.keys = new HashMap<String, IndexKey>();
            Iterator it = dict.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                JSONObject value = dict.getJSONObject(key);
                IndexKey indexKey = new IndexKey();
                indexKey.FromJsonObject(value);
                this.AddKey(key, indexKey);
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndexKeys", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String indexKeysString) throws LogException {
        try {
            JSONObject dict = JSONObject.fromObject((Object)indexKeysString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndexKeys", e.getMessage(), e, "");
        }
    }
}

