/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.ApsaraLogConfigInputDetail;
import com.aliyun.openservices.log.common.ConfigInputDetail;
import com.aliyun.openservices.log.common.DelimiterConfigInputDetail;
import com.aliyun.openservices.log.common.JsonConfigInputDetail;
import com.aliyun.openservices.log.common.StreamLogConfigInputDetail;
import com.aliyun.openservices.log.exception.LogException;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public abstract class CommonConfigInputDetail {
    protected boolean localStorage = true;
    protected ArrayList<String> filterRegex = new ArrayList();
    protected ArrayList<String> filterKey = new ArrayList();
    protected ArrayList<String> shardHashKey = new ArrayList();
    protected boolean enableTag = false;

    public boolean GetEnableTag() {
        return this.enableTag;
    }

    public void SetEnableTag(boolean enableTag) {
        this.enableTag = enableTag;
    }

    public boolean GetLocalStorage() {
        return this.localStorage;
    }

    public void SetLocalStorage(boolean localStorage) {
        this.localStorage = localStorage;
    }

    public void SetFilterKeyRegex(List<String> filterKey, List<String> filterRegex) {
        this.filterKey = new ArrayList<String>(filterKey);
        this.filterRegex = new ArrayList<String>(filterRegex);
    }

    public ArrayList<String> GetShardHashKey() {
        return this.shardHashKey;
    }

    public void SetShardHashKeyList(List<String> shardHashKey) {
        this.shardHashKey = new ArrayList<String>(shardHashKey);
    }

    public void SetShardHashKey(JSONArray shardHashKey) throws LogException {
        try {
            this.shardHashKey = new ArrayList();
            for (int i = 0; i < shardHashKey.size(); ++i) {
                this.shardHashKey.add(shardHashKey.getString(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToSetShardHashKey", e.getMessage(), e, "");
        }
    }

    public ArrayList<String> GetFilterRegex() {
        return this.filterRegex;
    }

    public void SetFilterRegex(JSONArray filterRegex) throws LogException {
        try {
            this.filterRegex = new ArrayList();
            for (int i = 0; i < filterRegex.size(); ++i) {
                this.filterRegex.add(filterRegex.getString(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToSetFilterRegex", e.getMessage(), e, "");
        }
    }

    public ArrayList<String> GetFilterKey() {
        return this.filterKey;
    }

    public void SetFilterKey(JSONArray filterKey) throws LogException {
        try {
            this.filterKey = new ArrayList();
            for (int i = 0; i < filterKey.size(); ++i) {
                this.filterKey.add(filterKey.getString(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToSetFilterKey", e.getMessage(), e, "");
        }
    }

    public abstract JSONObject ToJsonObject();

    public abstract void FromJsonObject(JSONObject var1) throws LogException;

    protected void CommonConfigToJsonObject(JSONObject jsonObj) {
        jsonObj.put((Object)"localStorage", (Object)this.localStorage);
        jsonObj.put((Object)"enableTag", (Object)this.enableTag);
        JSONArray filterRegexArray = new JSONArray();
        for (String string : this.filterRegex) {
            filterRegexArray.add((Object)string);
        }
        jsonObj.put((Object)"filterRegex", (Object)filterRegexArray);
        JSONArray filterKeyArray = new JSONArray();
        for (String fk : this.filterKey) {
            filterKeyArray.add((Object)fk);
        }
        jsonObj.put((Object)"filterKey", (Object)filterKeyArray);
        JSONArray jSONArray = new JSONArray();
        for (String shk : this.shardHashKey) {
            jSONArray.add((Object)shk);
        }
        jsonObj.put((Object)"shardHashKey", (Object)jSONArray);
    }

    protected void CommonConfigFromJsonObject(JSONObject inputDetail) throws LogException {
        try {
            this.localStorage = inputDetail.has("localStorage") ? inputDetail.getBoolean("localStorage") : true;
            this.enableTag = inputDetail.has("enableTag") ? inputDetail.getBoolean("enableTag") : false;
            if (inputDetail.has("filterRegex")) {
                this.SetFilterRegex(inputDetail.getJSONArray("filterRegex"));
            }
            if (inputDetail.has("filterKey")) {
                this.SetFilterKey(inputDetail.getJSONArray("filterKey"));
            }
            if (inputDetail.has("shardHashKey")) {
                this.SetShardHashKey(inputDetail.getJSONArray("shardHashKey"));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateInputDetail", e.getMessage(), e, "");
        }
    }

    public static CommonConfigInputDetail FromJsonStringS(String inputType, String jsonString) throws LogException {
        try {
            JSONObject inputDetail = JSONObject.fromObject((Object)jsonString);
            return CommonConfigInputDetail.FromJsonObjectS(inputType, inputDetail);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateInputDetail", e.getMessage(), e, "");
        }
    }

    public static CommonConfigInputDetail FromJsonObjectS(String inputType, JSONObject inputDetail) throws LogException {
        try {
            if (inputType.equals("syslog") || inputType.equals("streamlog")) {
                StreamLogConfigInputDetail res = new StreamLogConfigInputDetail();
                res.FromJsonObject(inputDetail);
                return res;
            }
            if (inputType.equals("file")) {
                if (inputDetail.containsKey((Object)"logType")) {
                    if (inputDetail.getString("logType").compareTo("json_log") == 0) {
                        JsonConfigInputDetail res = new JsonConfigInputDetail();
                        res.FromJsonObject(inputDetail);
                        return res;
                    }
                    if (inputDetail.getString("logType").compareTo("delimiter_log") == 0) {
                        DelimiterConfigInputDetail res = new DelimiterConfigInputDetail();
                        res.FromJsonObject(inputDetail);
                        return res;
                    }
                    if (inputDetail.getString("logType").compareTo("apsara_log") == 0) {
                        ApsaraLogConfigInputDetail res = new ApsaraLogConfigInputDetail();
                        res.FromJsonObject(inputDetail);
                        return res;
                    }
                    if (inputDetail.getString("logType").compareTo("common_reg_log") == 0) {
                        ConfigInputDetail res = new ConfigInputDetail();
                        res.FromJsonObject(inputDetail);
                        return res;
                    }
                    throw new LogException("FailToGenerateInputDetail", "invlaid logType", inputDetail.getString("logType"));
                }
                throw new LogException("FailToGenerateInputDetail", "logType field does not exist in input detail", "");
            }
            throw new LogException("FailToGenerateInputDetail", "invalid inputType", inputType);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateInputDetail", e.getMessage(), e, "");
        }
    }
}

