/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class IndexKey
implements Serializable {
    private static final long serialVersionUID = -6607480102839653253L;
    private List<String> token = new ArrayList<String>();
    private boolean caseSensitive;
    private boolean docValue;
    private boolean chn;
    private String alias = "";
    private String type = "text";

    public IndexKey() {
    }

    public IndexKey(List<String> token, boolean caseSensitive) {
        this.SetToken(token);
        this.caseSensitive = caseSensitive;
        this.type = "text";
        this.docValue = true;
        this.chn = false;
    }

    public IndexKey(List<String> token, boolean caseSensitive, String type) {
        this.SetToken(token);
        this.caseSensitive = caseSensitive;
        this.type = type;
        this.docValue = true;
        this.chn = false;
    }

    public IndexKey(List<String> token, boolean caseSensitive, String type, String alias) {
        this.SetToken(token);
        this.caseSensitive = caseSensitive;
        this.type = type;
        this.docValue = true;
        this.alias = alias;
        this.chn = false;
    }

    public IndexKey(IndexKey other) {
        this.SetToken(other.GetToken());
        this.caseSensitive = other.GetCaseSensitive();
        this.type = other.GetType();
        this.docValue = other.IsDocValue();
        this.alias = other.alias;
        this.chn = other.chn;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean IsChn() {
        return this.chn;
    }

    public void SetChn(boolean chn) {
        this.chn = chn;
    }

    public boolean IsDocValue() {
        return this.docValue;
    }

    public void SetDocValue(boolean docValue) {
        this.docValue = docValue;
    }

    public String GetType() {
        return this.type;
    }

    public void SetType(String type) {
        this.type = type;
    }

    public List<String> GetToken() {
        return this.token;
    }

    public boolean GetCaseSensitive() {
        return this.caseSensitive;
    }

    public void SetToken(List<String> token) {
        this.token = new ArrayList<String>(token);
    }

    public void SetCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public JSONObject ToRequestJson() throws LogException {
        JSONObject allKeys = new JSONObject();
        JSONArray tokenDict = new JSONArray();
        for (String v : this.token) {
            tokenDict.add((Object)v);
        }
        allKeys.put("type", (Object)this.GetType());
        if (this.GetType().equals("text")) {
            allKeys.put("token", (Object)tokenDict);
            allKeys.put("caseSensitive", (Object)this.GetCaseSensitive());
            allKeys.put("chn", (Object)this.IsChn());
        }
        allKeys.put("doc_value", (Object)this.IsDocValue());
        allKeys.put("alias", (Object)this.getAlias());
        return allKeys;
    }

    public String ToRequestString() throws LogException {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() throws LogException {
        JSONObject allKeys = this.ToRequestJson();
        return allKeys;
    }

    public String ToJsonString() throws LogException {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            if (dict.containsKey((Object)"chn")) {
                this.SetChn(dict.getBooleanValue("chn"));
            } else {
                this.SetChn(false);
            }
            if (dict.containsKey((Object)"alias")) {
                this.setAlias(dict.getString("alias"));
            }
            if (!dict.containsKey((Object)"doc_value")) {
                this.SetDocValue(false);
            } else {
                this.SetDocValue(dict.getBooleanValue("doc_value"));
            }
            boolean caseSensitive = false;
            if (dict.containsKey((Object)"caseSensitive")) {
                caseSensitive = dict.getBooleanValue("caseSensitive");
            }
            if (dict.containsKey((Object)"type")) {
                this.SetType(dict.getString("type"));
            } else {
                this.SetType("text");
            }
            this.SetCaseSensitive(caseSensitive);
            JSONArray tokenDict = new JSONArray();
            if (dict.containsKey((Object)"token")) {
                tokenDict = dict.getJSONArray("token");
            }
            this.token = new ArrayList<String>();
            for (int i = 0; i < tokenDict.size(); ++i) {
                this.token.add(tokenDict.getString(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndexKey", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String indexKeyString) throws LogException {
        try {
            JSONObject dict = JSONObject.parseObject((String)indexKeyString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndexKey", e.getMessage(), e, "");
        }
    }
}

