/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.proto.ProtobufRecordStreamWriter;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordPack;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.tunnel.io.Checksum;
import com.aliyun.odps.tunnel.io.CompressOption;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ProtobufRecordPack
extends RecordPack {
    private ProtobufRecordStreamWriter writer;
    private ByteArrayOutputStream byteos;
    private long count = 0L;
    private TableSchema schema;
    private CompressOption option = null;
    private boolean isComplete = false;

    public ProtobufRecordPack(TableSchema schema) throws IOException {
        this(schema, new Checksum());
    }

    public ProtobufRecordPack(TableSchema schema, Checksum checkSum) throws IOException {
        this(schema, checkSum, 0);
    }

    public ProtobufRecordPack(TableSchema schema, Checksum checkSum, int capacity) throws IOException {
        this(schema, checkSum, capacity, null);
    }

    public ProtobufRecordPack(TableSchema schema, Checksum checksum, CompressOption option) throws IOException {
        this(schema, checksum, 0, option);
    }

    public ProtobufRecordPack(TableSchema schema, Checksum checksum, int capacity, CompressOption option) throws IOException {
        this.byteos = capacity == 0 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(capacity);
        this.schema = schema;
        if (null != option) {
            this.option = option;
        }
        this.writer = new ProtobufRecordStreamWriter(schema, this.byteos, option);
        if (null != checksum) {
            this.writer.setCheckSum(checksum);
        }
    }

    @Override
    public void append(Record a) throws IOException {
        this.writer.write(a);
        ++this.count;
    }

    @Override
    public RecordReader getRecordReader() throws IOException {
        throw new UnsupportedOperationException("PBPack does not supported Read.");
    }

    public ByteArrayOutputStream getProtobufStream() throws IOException {
        if (!this.isComplete) {
            this.writer.flush();
        }
        return this.byteos;
    }

    public void complete() throws IOException {
        if (!this.isComplete) {
            this.writer.close();
            this.isComplete = true;
        }
    }

    public CompressOption getCompressOption() {
        return this.option;
    }

    public long getTotalBytes() throws IOException {
        return this.byteos.size();
    }

    protected long getTotalBytesWritten() throws IOException {
        this.writer.flush();
        return this.writer.getTotalBytes();
    }

    public Checksum getCheckSum() {
        return this.writer.getCheckSum();
    }

    public void reset() throws IOException {
        if (this.byteos != null) {
            this.byteos.reset();
        }
        this.count = 0L;
        this.writer = new ProtobufRecordStreamWriter(this.schema, this.byteos, this.option);
        this.isComplete = false;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void reset(Checksum checksum) throws IOException {
        this.reset();
        if (checksum != null) {
            this.writer.setCheckSum(checksum);
        }
    }

    public long getSize() {
        return this.count;
    }
}

