/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.proto.ProtobufRecordStreamReader;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.PackType;
import com.aliyun.odps.tunnel.io.ReadPackResult;
import com.aliyun.odps.tunnel.io.SeekPackResult;
import com.aliyun.odps.tunnel.io.proto.XstreamPack;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class PackReader {
    private RestClient tunnelServiceClient;
    private TableSchema tableSchema;
    private String path;
    private MessageDigest messageDigest;
    private Map<String, String> params;
    private Map<String, String> headers;
    private String currPackId;
    private String nextPackId;
    private PackType.ReadMode readMode;
    private CompressOption compressOption;
    private ProtobufRecordStreamReader protobufRecordStreamReader;

    public PackReader(RestClient tunnelServiceClient, TableSchema tableSchema, String path, Map<String, String> params, Map<String, String> headers) {
        this(tunnelServiceClient, tableSchema, path, params, headers, PackType.FIRST_PACK_ID);
    }

    public PackReader(RestClient tunnelServiceClient, TableSchema tableSchema, String path, Map<String, String> params, Map<String, String> headers, String packId) {
        this.tunnelServiceClient = tunnelServiceClient;
        this.tableSchema = tableSchema;
        this.path = path;
        this.params = params;
        this.headers = headers;
        this.currPackId = null;
        this.nextPackId = null;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.protobufRecordStreamReader = null;
        this.compressOption = new CompressOption();
        this.seek(packId, PackType.ReadMode.SEEK_CUR);
    }

    private boolean isValid(String pid) {
        return pid != null && !pid.equals(PackType.FIRST_PACK_ID) && !pid.equals(PackType.LAST_PACK_ID);
    }

    private void seek(String rpid, PackType.ReadMode mode) {
        if (rpid == null && mode != PackType.ReadMode.SEEK_BEGIN && mode != PackType.ReadMode.SEEK_END) {
            throw new IllegalArgumentException("Invalid pack id.");
        }
        if (mode == PackType.ReadMode.SEEK_NEXT && this.isValid(this.currPackId) && this.currPackId.equals(rpid) && this.isValid(this.nextPackId)) {
            rpid = this.nextPackId;
            mode = PackType.ReadMode.SEEK_CUR;
        } else {
            this.currPackId = null;
        }
        switch (mode) {
            case SEEK_BEGIN: {
                this.nextPackId = PackType.FIRST_PACK_ID;
                break;
            }
            case SEEK_END: {
                this.nextPackId = PackType.LAST_PACK_ID;
                break;
            }
            case SEEK_CUR: 
            case SEEK_NEXT: {
                this.nextPackId = rpid;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid pack read mode.");
            }
        }
        this.readMode = mode;
        this.protobufRecordStreamReader = null;
    }

    public SeekPackResult seek(long timeStamp) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>(this.params);
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        try {
            params.put("timestamp", Long.toString(timeStamp));
            Connection conn = this.tunnelServiceClient.connect(this.path, "GET", params, headers);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            String json = IOUtils.readStreamAsString(conn.getInputStream());
            JSONObject tree = JSON.parseObject((String)json);
            String node = tree.getString("PackId");
            if (node != null) {
                SeekPackResult startPack = new SeekPackResult(node);
                return startPack;
            }
            throw new TunnelException("get pack id fail");
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(e.getMessage(), e);
        }
    }

    public ReadPackResult read() throws TunnelException, IOException {
        this.protobufRecordStreamReader = null;
        HashMap<String, String> params = new HashMap<String, String>(this.params);
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        try {
            String strMode = this.readMode == PackType.ReadMode.SEEK_NEXT ? "AFTER_PACKID" : "AT_PACKID";
            params.put("packid", this.nextPackId);
            params.put("iteratemode", strMode);
            params.put("packnum", "1");
            Connection conn = this.tunnelServiceClient.connect(this.path, "GET", params, headers);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            String num = resp.getHeader("x-odps-pack-num");
            if (num.equals("0")) {
                return null;
            }
            InputStream in = conn.getInputStream();
            byte[] bytes = IOUtils.readFully(in);
            XstreamPack.XStreamPack pack = XstreamPack.XStreamPack.parseFrom(bytes);
            bytes = pack.getPackData().toByteArray();
            this.protobufRecordStreamReader = new ProtobufRecordStreamReader(this.tableSchema, new ByteArrayInputStream(bytes), this.compressOption);
            String npid = resp.getHeader("x-odps-next-packid");
            String cpid = resp.getHeader("x-odps-current-packid");
            long timeStamp = new Long(resp.getHeader("x-odps-pack-timestamp"));
            if (!npid.equals(PackType.LAST_PACK_ID)) {
                this.nextPackId = npid;
                this.readMode = PackType.ReadMode.SEEK_CUR;
                this.currPackId = cpid;
            } else {
                this.nextPackId = cpid;
                this.readMode = PackType.ReadMode.SEEK_NEXT;
                this.currPackId = null;
            }
            ArrayList<Record> records = new ArrayList<Record>();
            Record r = null;
            while ((r = this.protobufRecordStreamReader.read()) != null) {
                records.add(r);
            }
            return new ReadPackResult(cpid, npid, timeStamp, records, pack.hasPackMeta() ? pack.getPackMeta().toByteArray() : null);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(e.getMessage(), e);
        }
    }

    public ReadPackResult read(String packId, PackType.ReadMode mode) throws TunnelException, IOException {
        this.seek(packId, mode);
        return this.read();
    }

    private String generatorMD5(byte[] bytes) {
        byte[] digest = this.messageDigest.digest(bytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }
}

