/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TunnelException
extends OdpsException {
    private String errorMsg;

    public TunnelException() {
    }

    public TunnelException(String requestId, InputStream in, Integer status) {
        this(in);
        this.requestId = requestId;
        this.status = status;
    }

    public TunnelException(String message) {
        super(message);
        this.errorCode = "Local Error";
        this.errorMsg = message;
    }

    public TunnelException(String message, Throwable cause) {
        super(message, cause);
        this.errorCode = "Local Error";
        this.errorMsg = message;
    }

    public TunnelException(InputStream is) {
        String message = "";
        try {
            byte[] bytes = IOUtils.readFully(is);
            message = new String(bytes);
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            this.loadFromJson(bis);
        }
        catch (Exception e) {
            throw new RuntimeException("Parse responsed failed: '" + message + "'", e);
        }
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        if (this.requestId != null) {
            sb.append("RequestId=").append(this.requestId);
        }
        if (this.errorCode != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("ErrorCode=").append(this.errorCode);
        }
        if (this.errorMsg != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (this.requestId != null || this.errorCode != null) {
                sb.append("ErrorMessage=");
            }
            sb.append(this.errorMsg);
        }
        return sb.toString();
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Deprecated
    public void loadFromJson(InputStream is) throws TunnelException, IOException {
        try {
            String json = IOUtils.readStreamAsString(is);
            JSONObject tree = JSONObject.parseObject((String)json);
            String node = tree.getString("Code");
            if (node != null) {
                this.errorCode = node;
            }
            if ((node = tree.getString("Message")) != null) {
                this.errorMsg = node;
            }
        }
        catch (Exception e) {
            throw new TunnelException("Parse response failed", e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

