/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.io.PackReader;
import com.aliyun.odps.tunnel.io.ReplicatorStatus;
import com.aliyun.odps.tunnel.io.StreamReader;
import com.aliyun.odps.tunnel.io.StreamWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public class StreamClient {
    private String projectName;
    private String tableName;
    private Configuration conf;
    private RestClient tunnelServiceClient;
    private HashMap<String, String> headers;
    private TableSchema schema = new TableSchema();
    private List<Long> shards = new ArrayList<Long>();
    private final Long MAX_WAITING_MILLISECOND = 120000L;

    public StreamClient(Configuration conf, String projectName, String tableName) throws TunnelException {
        this.conf = conf;
        this.projectName = projectName;
        this.tableName = tableName;
        this.headers = new HashMap();
        this.headers.put("Content-Length", String.valueOf(0));
        this.headers.put("x-odps-tunnel-stream-version", "1");
        this.initiate();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void loadShard(long shardNumber) throws TunnelException {
        if (shardNumber < 0L) {
            throw new TunnelException("invalid shard number");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        String path = this.getResource() + "/shards";
        Connection conn = null;
        try {
            params.put("shardnumber", Long.toString(shardNumber));
            conn = this.tunnelServiceClient.connect(path, "POST", params, headers);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
        }
        catch (IOException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (OdpsException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Deprecated
    public void loadShard(int shardNumber) throws TunnelException {
        this.loadShard((long)shardNumber);
    }

    public void waitForShardLoad() throws TunnelException {
        this.waitForShardLoad(this.MAX_WAITING_MILLISECOND);
    }

    public void waitForShardLoad(long timeout) throws TunnelException {
        if (timeout <= 0L) {
            throw new TunnelException("invalid waiting time");
        }
        long waitTime = timeout > this.MAX_WAITING_MILLISECOND ? this.MAX_WAITING_MILLISECOND : timeout;
        long now = System.currentTimeMillis();
        long end = now + waitTime;
        while (now < end) {
            try {
                if (this.isShardLoadCompleted()) {
                    return;
                }
                Thread.sleep(10000L);
                now = System.currentTimeMillis();
            }
            catch (Exception e) {
                throw new TunnelException(e.getMessage(), e);
            }
        }
        if (!this.isShardLoadCompleted()) {
            throw new TunnelException("load shard timeout");
        }
    }

    private boolean isShardLoadCompleted() {
        try {
            HashMap<Long, ShardState> shardStatusMap = this.getShardStatus();
            for (Map.Entry<Long, ShardState> entry : shardStatusMap.entrySet()) {
                ShardState status = entry.getValue();
                if (status == ShardState.LOADED) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public HashMap<Long, ShardState> getShardStatus() throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> hdrs = new HashMap<String, String>(this.headers);
        try {
            String path = this.getResource() + "/shards";
            hdrs.put("x-odps-tunnel-version", String.valueOf(4));
            params.put("shardstatus", null);
            Connection conn = this.tunnelServiceClient.connect(path, "GET", params, hdrs);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            return this.loadShardStatusFromJson(conn.getInputStream());
        }
        catch (Exception e) {
            throw new TunnelException(e.getMessage(), e);
        }
    }

    public ReplicatorStatus QueryReplicatorStatus(long shardId, PartitionSpec partitionSpec) throws TunnelException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        params.put("query", "replicator");
        if (partitionSpec != null && partitionSpec.toString().length() > 0) {
            params.put("partition", partitionSpec.toString().replaceAll("'", ""));
        }
        String path = this.getStreamResource(shardId);
        Connection conn = null;
        try {
            conn = this.tunnelServiceClient.connect(path, "GET", params, headers);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            ReplicatorStatus replicatorStatus = new ReplicatorStatus(conn.getInputStream());
            return replicatorStatus;
        }
        catch (IOException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (OdpsException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ReplicatorStatus QueryReplicatorStatus(long shardId) throws TunnelException {
        return this.QueryReplicatorStatus(shardId, null);
    }

    private void initiate() throws TunnelException {
        block13: {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("query", "meta");
            params.put("type", "stream");
            this.tunnelServiceClient = this.conf.newRestClient(this.projectName);
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.getResource(), "GET", params, this.headers);
                Response resp = conn.getResponse();
                if (resp.isOK()) {
                    this.loadFromJson(conn.getInputStream());
                    break block13;
                }
                TunnelException e = new TunnelException(conn.getInputStream());
                e.setRequestId(resp.getHeader("x-odps-request-id"));
                throw e;
            }
            catch (IOException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public TableSchema getStreamSchema() {
        return this.schema;
    }

    public List<Long> getShardList() {
        return this.shards;
    }

    @Deprecated
    public StreamWriter openStreamWriter(String shardId) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("Content-Type", "application/octet-stream");
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new StreamWriter(this.tunnelServiceClient, this.getStreamResource(shardId), params, headers);
    }

    public StreamWriter openStreamWriter(long shardId) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("Content-Type", "application/octet-stream");
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new StreamWriter(this.tunnelServiceClient, this.getStreamResource(shardId), params, headers);
    }

    public StreamWriter openStreamWriter() throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("Content-Type", "application/octet-stream");
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new StreamWriter(this.tunnelServiceClient, this.getStreamResource(), params, headers);
    }

    public StreamReader openStreamReader(long shardId) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new StreamReader(this.tunnelServiceClient, this.schema, this.getStreamResource(shardId), params, headers);
    }

    public StreamReader openStreamReader(long shardId, String packId) throws TunnelException, IOException {
        if (packId == null) {
            throw new IllegalArgumentException("Invalid pack id.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new StreamReader(this.tunnelServiceClient, this.schema, this.getStreamResource(shardId), params, headers, packId);
    }

    public PackReader openPackReader(long shardId) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new PackReader(this.tunnelServiceClient, this.schema, this.getStreamResource(shardId), params, headers);
    }

    public PackReader openPackReader(long shardId, String packId) throws TunnelException, IOException {
        if (packId == null) {
            throw new IllegalArgumentException("Invalid pack id.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new PackReader(this.tunnelServiceClient, this.schema, this.getStreamResource(shardId), params, headers, packId);
    }

    private String getResource() {
        return this.conf.getResource(this.projectName, this.tableName);
    }

    private String getStreamResource(String shardId) {
        return this.conf.getStreamUploadResource(this.projectName, this.tableName, shardId);
    }

    private String getStreamResource(long shardId) {
        return this.conf.getStreamUploadResource(this.projectName, this.tableName, shardId);
    }

    private String getStreamResource() {
        return this.conf.getStreamUploadResource(this.projectName, this.tableName);
    }

    private void loadFromJson(InputStream is) throws TunnelException {
        block5: {
            try {
                String json = IOUtils.readStreamAsString(is);
                JSONObject tree = JSONObject.parseObject((String)json);
                JSONObject schemaNode = tree.getJSONObject("Schema");
                if (schemaNode == null) {
                    throw new TunnelException("get table schema fail");
                }
                this.schema = new TunnelTableSchema(schemaNode);
                JSONArray node = tree.getJSONArray("Shards");
                if (node != null) {
                    for (int i = 0; i < node.size(); ++i) {
                        long shardId = node.getLongValue(i);
                        this.shards.add(shardId);
                    }
                    break block5;
                }
                throw new TunnelException("get shard fail");
            }
            catch (Exception e) {
                throw new TunnelException("Invalid json content.", e);
            }
        }
    }

    private HashMap<Long, ShardState> loadShardStatusFromJson(InputStream is) throws TunnelException {
        try {
            HashMap<Long, ShardState> shardStatus = new HashMap<Long, ShardState>();
            String json = IOUtils.readStreamAsString(is);
            JSONObject tree = JSONObject.parseObject((String)json);
            JSONArray node = tree.getJSONArray("ShardStatus");
            if (node != null) {
                for (int i = 0; i < node.size(); ++i) {
                    JSONObject status = node.getJSONObject(i);
                    ShardState state = ShardState.valueOf(status.getString("State").toUpperCase());
                    shardStatus.put(Long.parseLong(status.getString("ShardId")), state);
                }
            }
            return shardStatus;
        }
        catch (Exception e) {
            throw new TunnelException("Invalid json content.", e);
        }
    }

    public static enum ShardState {
        UNLOADED,
        LOADED,
        LOADING;

    }
}

