/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.odps.Column;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;

public class InstanceTunnel {
    private Configuration config;

    public InstanceTunnel(Odps odps) {
        this.config = new Configuration(odps);
    }

    public DownloadSession createDownloadSession(String projectName, String instanceID) throws TunnelException {
        return new DownloadSession(projectName, instanceID, null);
    }

    public DownloadSession createDownloadSession(String projectName, String instanceID, boolean limitEnabled) throws TunnelException {
        return new DownloadSession(projectName, instanceID, null, limitEnabled);
    }

    public DownloadSession getDownloadSession(String projectName, String id) throws TunnelException {
        return new DownloadSession(projectName, null, id);
    }

    private String getResource(String projectName, String instanceID) {
        return ResourceBuilder.buildInstanceResource(projectName, instanceID);
    }

    public void setEndpoint(String endpoint) {
        try {
            URI u = new URI(endpoint);
            this.config.setEndpoint(u);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint.");
        }
    }

    public class DownloadSession {
        private final String instanceID;
        private String id;
        private String projectName;
        private long count;
        private boolean limitEnabled;
        private TableSchema schema = new TableSchema();
        private DownloadStatus status = DownloadStatus.UNKNOWN;
        private Configuration conf;
        private RestClient tunnelServiceClient;

        public DownloadSession(String projectName, String instanceID, String downloadId) throws TunnelException {
            this(projectName, instanceID, downloadId, false);
        }

        private DownloadSession(String projectName, String instanceID, String downloadId, boolean limitEnabled) throws TunnelException {
            this.conf = InstanceTunnel.this.config;
            this.projectName = projectName;
            this.instanceID = instanceID;
            this.id = downloadId;
            this.limitEnabled = limitEnabled;
            this.tunnelServiceClient = this.conf.newRestClient(projectName);
            if (this.id == null) {
                this.initiate();
            } else {
                this.reload();
            }
        }

        public TunnelRecordReader openRecordReader(long start, long count) throws TunnelException, IOException {
            return this.openRecordReader(start, count, false);
        }

        public TunnelRecordReader openRecordReader(long start, long count, boolean compress) throws TunnelException, IOException {
            return this.openRecordReader(start, count, compress, null);
        }

        public TunnelRecordReader openRecordReader(long start, long count, CompressOption compress) throws TunnelException, IOException {
            return this.openRecordReader(start, count, compress, null);
        }

        public TunnelRecordReader openRecordReader(long start, long count, boolean compress, List<Column> columns) throws TunnelException, IOException {
            CompressOption option = compress ? this.conf.getCompressOption() : new CompressOption(CompressOption.CompressAlgorithm.ODPS_RAW, 0, 0);
            return this.openRecordReader(start, count, option, columns);
        }

        public TunnelRecordReader openRecordReader(long start, long count, CompressOption compress, List<Column> columns) throws TunnelException, IOException {
            return new TunnelRecordReader(start, count, columns, compress, this.tunnelServiceClient, this);
        }

        private void initiate() throws TunnelException {
            block14: {
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Length", String.valueOf(0));
                params.put("downloads", null);
                if (this.limitEnabled) {
                    params.put("instance_tunnel_limit_enabled", null);
                }
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        break block14;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    e.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException("Failed to create download session with tunnel endpoint " + this.tunnelServiceClient.getEndpoint(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        private void reload() throws TunnelException {
            block13: {
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Length", String.valueOf(0));
                params.put("downloadid", this.id);
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource(), "GET", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        break block13;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    e.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public TableSchema getSchema() {
            return this.schema;
        }

        public long getRecordCount() {
            return this.count;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getInstanceID() {
            return this.instanceID;
        }

        public String getId() {
            return this.id;
        }

        public DownloadStatus getStatus() throws TunnelException, IOException {
            this.reload();
            return this.status;
        }

        private String getResource() {
            return InstanceTunnel.this.getResource(this.projectName, this.instanceID);
        }

        private void loadFromJson(InputStream is) throws TunnelException {
            try {
                JSONObject node3;
                Long node2;
                String json = IOUtils.readStreamAsString(is);
                JSONObject tree = JSONObject.parseObject((String)json);
                String node = tree.getString("DownloadID");
                if (node != null) {
                    this.id = node;
                }
                if ((node = tree.getString("Status")) != null) {
                    this.status = DownloadStatus.valueOf(node.toUpperCase());
                }
                if ((node2 = tree.getLong("RecordCount")) != null) {
                    this.count = node2;
                }
                if ((node3 = tree.getJSONObject("Schema")) != null) {
                    this.schema = new TunnelTableSchema(node3);
                }
            }
            catch (Exception e) {
                throw new TunnelException("Invalid json content.", e);
            }
        }
    }

    public static enum DownloadStatus {
        UNKNOWN,
        NORMAL,
        CLOSED,
        EXPIRED;

    }
}

