/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.datahub;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.commons.proto.XstreamPack;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.datahub.DatahubException;
import com.aliyun.odps.datahub.DatahubRecordPack;
import com.aliyun.odps.datahub.WritePackResult;
import com.aliyun.odps.rest.RestClient;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class DatahubWriter {
    private RestClient datahubServiceClient;
    private String path;
    private MessageDigest messageDigest;
    private Map<String, String> params;
    private Map<String, String> headers;
    private WritePackResult lastPackResult;

    public DatahubWriter(RestClient datahubServiceClient, String path, HashMap<String, String> params, Map<String, String> headers) {
        this.datahubServiceClient = datahubServiceClient;
        this.path = path;
        this.params = params;
        this.headers = headers;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public WritePackResult write(DatahubRecordPack recordPack) throws OdpsException, IOException {
        return this.write(null, recordPack, null, null);
    }

    public WritePackResult write(DatahubRecordPack recordPack, byte[] meta) throws OdpsException, IOException {
        return this.write(null, recordPack, meta, null);
    }

    public WritePackResult write(DatahubRecordPack recordPack, Map<String, String> meta) throws OdpsException, IOException {
        return this.write(null, recordPack, null, meta);
    }

    public WritePackResult write(PartitionSpec partitionSpec, DatahubRecordPack recordPack, Map<String, String> meta) throws OdpsException, IOException {
        return this.write(partitionSpec, recordPack, null, meta);
    }

    public WritePackResult write(PartitionSpec partitionSpec, DatahubRecordPack recordPack) throws OdpsException, IOException {
        return this.write(partitionSpec, recordPack, null, null);
    }

    private WritePackResult write(PartitionSpec partitionSpec, DatahubRecordPack recordPack, byte[] meta, Map<String, String> kvMeta) throws OdpsException, IOException {
        HashMap<String, String> params = new HashMap<String, String>(this.params);
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("Content-Encoding", "deflate");
        try {
            byte[] bytes = recordPack.getByteArray();
            if (null == bytes || 0 == bytes.length) {
                throw new DatahubException("record pack is empty.");
            }
            XstreamPack.XStreamPack.Builder pack = XstreamPack.XStreamPack.newBuilder();
            pack.setPackData(ByteString.copyFrom((byte[])bytes));
            if (null != meta) {
                pack.setPackMeta(ByteString.copyFrom((byte[])meta));
            }
            XstreamPack.KVMapPB.Builder kvMap = XstreamPack.KVMapPB.newBuilder();
            if (null != kvMeta) {
                for (Map.Entry<String, String> entry : kvMeta.entrySet()) {
                    XstreamPack.BytesPairPB.Builder kv = XstreamPack.BytesPairPB.newBuilder();
                    String key = entry.getKey();
                    if ("__partition__".equals(key)) {
                        throw new DatahubException("Invalid PackMeta: \"__partition__\"!");
                    }
                    kv.setKey(ByteString.copyFrom((byte[])key.getBytes("UTF-8")));
                    kv.setValue(ByteString.copyFrom((byte[])entry.getValue().getBytes("UTF-8")));
                    kvMap.addItems(kv);
                }
            }
            pack.setKvMeta(kvMap);
            bytes = pack.build().toByteArray();
            if (partitionSpec != null && partitionSpec.toString().length() > 0) {
                params.put("partition", partitionSpec.toString().replaceAll("'", ""));
            }
            params.put("recordcount", String.valueOf(recordPack.getRecordCount()));
            headers.put("Content-MD5", this.generatorMD5(bytes));
            Response resp = this.datahubServiceClient.requestForRawResponse(this.path, "PUT", params, headers, new ByteArrayInputStream(bytes), bytes.length);
            if (!resp.isOK()) {
                DatahubException ex = new DatahubException(new ByteArrayInputStream(resp.getBody()));
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(resp.getBody());
            this.loadFromJson(in);
        }
        catch (DatahubException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DatahubException(e.getMessage(), e);
        }
        return this.lastPackResult;
    }

    private void loadFromJson(InputStream is) throws OdpsException {
        try {
            String json = IOUtils.readStreamAsString(is);
            JSONObject tree = JSON.parseObject((String)json);
            String node = tree.getString("PackId");
            if (node == null) {
                throw new DatahubException("get pack id fail");
            }
            this.lastPackResult = new WritePackResult(node);
        }
        catch (Exception e) {
            throw new DatahubException("Invalid json content.", e);
        }
    }

    private String generatorMD5(byte[] bytes) {
        byte[] digest = this.messageDigest.digest(bytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }
}

