/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.proto;

import com.aliyun.odps.Column;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.data.AbstractChar;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.IntervalDayTime;
import com.aliyun.odps.data.IntervalYearMonth;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordPack;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.tunnel.io.Checksum;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.ProtobufRecordPack;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.SnappyFramedOutputStream;

public class ProtobufRecordStreamWriter
implements RecordWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufRecordStreamWriter.class);
    private CountingOutputStream bou;
    private Column[] columns;
    private CodedOutputStream out;
    private long count;
    private Checksum crc = new Checksum();
    private Checksum crccrc = new Checksum();
    private Deflater def;

    public ProtobufRecordStreamWriter(TableSchema schema, OutputStream out) throws IOException {
        this(schema, out, new CompressOption());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProtobufRecordStreamWriter(TableSchema schema, OutputStream out, CompressOption option) throws IOException {
        OutputStream tmpOut;
        this.columns = schema.getColumns().toArray(new Column[0]);
        if (option != null) {
            if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                this.def = new Deflater();
                this.def.setLevel(option.level);
                this.def.setStrategy(option.strategy);
                tmpOut = new DeflaterOutputStream(out, this.def);
            } else if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_SNAPPY)) {
                tmpOut = new SnappyFramedOutputStream(out);
            } else {
                if (!option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_RAW)) throw new IOException("invalid compression option.");
                tmpOut = out;
            }
        } else {
            tmpOut = out;
        }
        this.bou = new CountingOutputStream(tmpOut);
        this.out = CodedOutputStream.newInstance((OutputStream)this.bou);
    }

    static void writeRawBytes(byte[] value, CodedOutputStream out) throws IOException {
        out.writeRawVarint32(value.length);
        out.writeRawBytes(value);
    }

    @Override
    public void write(Record r) throws IOException {
        int columnCount;
        int recordValues = r.getColumnCount();
        if (recordValues > (columnCount = this.columns.length)) {
            LOG.error("Record values more than schema. record columns: {}, schema columns: {}.", (Object)recordValues, (Object)columnCount);
            throw new IOException("record values more than schema.");
        }
        long bytesSent = this.bou.getByteCount();
        for (int i = 0; i < columnCount && i < recordValues; ++i) {
            Object v = r.get(i);
            if (v == null) continue;
            int pbIdx = i + 1;
            this.crc.update(pbIdx);
            TypeInfo typeInfo = this.columns[i].getTypeInfo();
            this.writeFieldTag(pbIdx, typeInfo);
            this.writeField(v, typeInfo);
        }
        int checksum = (int)this.crc.getValue();
        this.out.writeUInt32(33553408, checksum);
        if (LOG.isDebugEnabled() && this.bou.getByteCount() != bytesSent) {
            LOG.debug("ProtobufStreamWriter({}) finish writing record {}, bytes sent to output stream til now: {}.", new Object[]{System.identityHashCode(this), this.count, this.bou.getByteCount()});
        }
        this.crc.reset();
        this.crccrc.update(checksum);
        ++this.count;
    }

    private void writeFieldTag(int pbIdx, TypeInfo typeInfo) throws IOException {
        switch (typeInfo.getOdpsType()) {
            case DATETIME: 
            case BOOLEAN: 
            case BIGINT: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case DATE: 
            case INTERVAL_YEAR_MONTH: {
                this.out.writeTag(pbIdx, 0);
                break;
            }
            case DOUBLE: {
                this.out.writeTag(pbIdx, 1);
                break;
            }
            case FLOAT: {
                this.out.writeTag(pbIdx, 5);
                break;
            }
            case INTERVAL_DAY_TIME: 
            case TIMESTAMP: 
            case STRING: 
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case DECIMAL: 
            case ARRAY: 
            case MAP: 
            case STRUCT: {
                this.out.writeTag(pbIdx, 2);
                break;
            }
            default: {
                throw new IOException("Invalid data type: " + typeInfo);
            }
        }
    }

    private void writeField(Object v, TypeInfo typeInfo) throws IOException {
        switch (typeInfo.getOdpsType()) {
            case BOOLEAN: {
                boolean value = (Boolean)v;
                this.crc.update(value);
                this.out.writeBoolNoTag(value);
                break;
            }
            case DATETIME: {
                java.util.Date value = (java.util.Date)v;
                Long longValue = DateUtils.date2ms(value);
                this.crc.update(longValue);
                this.out.writeSInt64NoTag(longValue.longValue());
                break;
            }
            case DATE: {
                Long longValue = DateUtils.getDayOffset((Date)v);
                this.crc.update(longValue);
                this.out.writeSInt64NoTag(longValue.longValue());
                break;
            }
            case TIMESTAMP: {
                Integer nano = ((Timestamp)v).getNanos();
                Long value = (((Timestamp)v).getTime() - (long)(nano / 1000000)) / 1000L;
                this.crc.update(value);
                this.crc.update(nano);
                this.out.writeSInt64NoTag(value.longValue());
                this.out.writeSInt32NoTag(nano.intValue());
                break;
            }
            case INTERVAL_DAY_TIME: {
                Long value = ((IntervalDayTime)v).getTotalSeconds();
                Integer nano = ((IntervalDayTime)v).getNanos();
                this.crc.update(value);
                this.crc.update(nano);
                this.out.writeSInt64NoTag(value.longValue());
                this.out.writeSInt32NoTag(nano.intValue());
                break;
            }
            case CHAR: 
            case VARCHAR: {
                byte[] bytes = ((AbstractChar)v).getValue().getBytes("UTF-8");
                this.crc.update(bytes, 0, bytes.length);
                ProtobufRecordStreamWriter.writeRawBytes(bytes, this.out);
                break;
            }
            case STRING: {
                byte[] bytes;
                if (v instanceof String) {
                    String value = (String)v;
                    bytes = value.getBytes("UTF-8");
                } else {
                    bytes = (byte[])v;
                }
                this.crc.update(bytes, 0, bytes.length);
                ProtobufRecordStreamWriter.writeRawBytes(bytes, this.out);
                break;
            }
            case BINARY: {
                byte[] bytes = ((Binary)v).data();
                this.crc.update(bytes, 0, bytes.length);
                ProtobufRecordStreamWriter.writeRawBytes(bytes, this.out);
                break;
            }
            case DOUBLE: {
                double value = (Double)v;
                this.crc.update(value);
                this.out.writeDoubleNoTag(value);
                break;
            }
            case FLOAT: {
                float value = ((Float)v).floatValue();
                this.crc.update(value);
                this.out.writeFloatNoTag(value);
                break;
            }
            case BIGINT: {
                long value = (Long)v;
                this.crc.update(value);
                this.out.writeSInt64NoTag(value);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                long value = ((IntervalYearMonth)v).getTotalMonths();
                this.crc.update(value);
                this.out.writeSInt64NoTag(value);
                break;
            }
            case INT: {
                long value = ((Integer)v).longValue();
                this.crc.update(value);
                this.out.writeSInt64NoTag(value);
                break;
            }
            case SMALLINT: {
                long value = ((Short)v).longValue();
                this.crc.update(value);
                this.out.writeSInt64NoTag(value);
                break;
            }
            case TINYINT: {
                long value = ((Byte)v).longValue();
                this.crc.update(value);
                this.out.writeSInt64NoTag(value);
                break;
            }
            case DECIMAL: {
                String value = ((BigDecimal)v).toPlainString();
                byte[] bytes = value.getBytes("UTF-8");
                this.crc.update(bytes, 0, bytes.length);
                ProtobufRecordStreamWriter.writeRawBytes(bytes, this.out);
                break;
            }
            case ARRAY: {
                this.writeArray((List)v, ((ArrayTypeInfo)typeInfo).getElementTypeInfo());
                break;
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                this.writeMap((Map)v, mapTypeInfo.getKeyTypeInfo(), mapTypeInfo.getValueTypeInfo());
                break;
            }
            case STRUCT: {
                this.writeStruct((Struct)v, (StructTypeInfo)typeInfo);
                break;
            }
            default: {
                throw new IOException("Invalid data type: " + typeInfo);
            }
        }
    }

    private void writeStruct(Struct object, StructTypeInfo typeInfo) throws IOException {
        List fieldTypeInfos = typeInfo.getFieldTypeInfos();
        for (int i = 0; i < fieldTypeInfos.size(); ++i) {
            if (object.getFieldValue(i) == null) {
                this.out.writeBoolNoTag(true);
                continue;
            }
            this.out.writeBoolNoTag(false);
            this.writeField(object.getFieldValue(i), (TypeInfo)fieldTypeInfos.get(i));
        }
    }

    private void writeArray(List v, TypeInfo type) throws IOException {
        this.out.writeInt32NoTag(v.size());
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i) == null) {
                this.out.writeBoolNoTag(true);
                continue;
            }
            this.out.writeBoolNoTag(false);
            this.writeField(v.get(i), type);
        }
    }

    private void writeMap(Map v, TypeInfo keyType, TypeInfo valueType) throws IOException {
        ArrayList keyList = new ArrayList();
        ArrayList valueList = new ArrayList();
        for (Map.Entry entry : v.entrySet()) {
            keyList.add(entry.getKey());
            valueList.add(entry.getValue());
        }
        this.writeArray(keyList, keyType);
        this.writeArray(valueList, valueType);
    }

    @Override
    public void close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ProtobufStreamWriter({}) start closing, bytes sent to output stream til now: {}.", (Object)System.identityHashCode(this), (Object)this.bou.getByteCount());
        }
        try {
            this.out.writeSInt64(0x1FFFFFE, this.count);
            this.out.writeUInt32(0x1FFFFFF, (int)this.crccrc.getValue());
            this.out.flush();
            this.bou.close();
        }
        finally {
            if (this.def != null) {
                this.def.end();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ProtobufStreamWriter({}) finish closing, bytes sent to output stream til now: {}.", (Object)System.identityHashCode(this), (Object)this.bou.getByteCount());
        }
    }

    public long getTotalBytes() {
        return this.bou.getByteCount();
    }

    @Deprecated
    public void write(RecordPack pack) throws IOException {
        if (pack instanceof ProtobufRecordPack) {
            ProtobufRecordPack pbPack = (ProtobufRecordPack)pack;
            pbPack.getProtobufStream().writeTo((OutputStream)this.bou);
            this.count += pbPack.getSize();
            this.setCheckSum(pbPack.getCheckSum());
        } else {
            Record record;
            RecordReader reader = pack.getRecordReader();
            while ((record = reader.read()) != null) {
                this.write(record);
            }
        }
    }

    public void flush() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ProtobufStreamWriter({}) start to flush, bytes sent to output stream til now: {}.", (Object)System.identityHashCode(this), (Object)this.bou.getByteCount());
        }
        this.out.flush();
        if (LOG.isDebugEnabled()) {
            LOG.debug("ProtobufStreamWriter({}) finish to flush, bytes sent to output stream til now: {}.", (Object)System.identityHashCode(this), (Object)this.bou.getByteCount());
        }
    }

    public Checksum getCheckSum() {
        return this.crccrc;
    }

    public void setCheckSum(Checksum checkSum) {
        this.crccrc = checkSum;
    }
}

