/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.account;

import com.aliyun.odps.account.RequestSigner;
import com.aliyun.odps.account.SecurityUtils;
import com.aliyun.odps.commons.transport.Request;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunRequestSigner
implements RequestSigner {
    private static final Logger LOG = LoggerFactory.getLogger(AliyunRequestSigner.class);
    private String accessId;
    private String accessKey;

    public AliyunRequestSigner(String accessId, String accessKey) {
        if (accessId == null || accessId.length() == 0) {
            throw new IllegalArgumentException("AccessId should not be empty.");
        }
        if (accessKey == null || accessKey.length() == 0) {
            throw new IllegalArgumentException("AccessKey should not be empty.");
        }
        this.accessId = accessId;
        this.accessKey = accessKey;
    }

    @Override
    public void sign(String resource, Request req) {
        req.getHeaders().put("Authorization", this.getSignature(resource, req));
    }

    public String getSignature(String resource, Request req) {
        try {
            resource = URLDecoder.decode(resource, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        String strToSign = SecurityUtils.buildCanonicalString(resource, req, "x-odps-");
        LOG.trace("String to sign {}", (Object)strToSign);
        byte[] crypto = new byte[]{};
        try {
            crypto = SecurityUtils.hmacsha1Signature(strToSign.getBytes("UTF-8"), this.accessKey.getBytes());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        String signature = Base64.encodeBase64String((byte[])crypto).trim();
        return "ODPS " + this.accessId + ":" + signature;
    }
}

