/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.odps.Instance;
import com.aliyun.odps.InstanceFilter;
import com.aliyun.odps.Job;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsHooks;
import com.aliyun.odps.Task;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class Instances
implements Iterable<Instance> {
    private Odps odps;
    private RestClient client;
    private String defaultRunningCluster;

    public String getDefaultRunningCluster() {
        return this.defaultRunningCluster;
    }

    public void setDefaultRunningCluster(String defaultRunningCluster) {
        this.defaultRunningCluster = defaultRunningCluster;
    }

    Instances(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Instance create(Job job) throws OdpsException {
        return this.create(this.getDefaultProjectName(), job);
    }

    public Instance create(Task task) throws OdpsException {
        return this.create(this.getDefaultProjectName(), task);
    }

    public Instance create(Task task, int priority) throws OdpsException {
        return this.create(this.getDefaultProjectName(), task, priority);
    }

    public Instance create(Task task, int priority, String runningCluster) throws OdpsException {
        return this.create(this.getDefaultProjectName(), task, priority, runningCluster);
    }

    public Instance get(String id) {
        return this.get(this.getDefaultProjectName(), id);
    }

    public Instance get(String projectName, String id) {
        Instance.TaskStatusModel model = new Instance.TaskStatusModel();
        model.name = id;
        return new Instance(projectName, model, null, this.odps);
    }

    public boolean exists(String id) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), id);
    }

    public boolean exists(String projectName, String id) throws OdpsException {
        try {
            Instance i = this.get(projectName, id);
            i.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public Instance create(String projectName, Task task) throws OdpsException {
        return this.create(projectName, task, null, null);
    }

    public Instance create(String projectName, Task task, int priority) throws OdpsException {
        return this.create(projectName, task, priority, this.defaultRunningCluster);
    }

    public Instance create(String projectName, Task task, int priority, String runningCluster) throws OdpsException {
        return this.create(projectName, task, new Integer(priority), runningCluster);
    }

    public Instance create(String projectName, Task task, Integer priority, String runningCluster) throws OdpsException {
        return this.create(projectName, task, priority, runningCluster, null);
    }

    public Instance create(String projectName, Task task, Integer priority, String runningCluster, String jobName) throws OdpsException {
        Job job = new Job();
        job.addTask(task);
        if (priority != null) {
            if (priority < 0) {
                throw new OdpsException("Priority must more than or equal to zero.");
            }
            job.setPriority(priority);
        }
        job.setRunningCluster(runningCluster);
        if (jobName != null) {
            job.setName(jobName);
        }
        return this.create(projectName, job);
    }

    Instance create(String project, Job job) throws OdpsException {
        if (project == null) {
            throw new IllegalArgumentException("project required.");
        }
        if (job == null) {
            throw new IllegalArgumentException("Job required.");
        }
        if (job.getTasks().size() == 0) {
            throw new IllegalArgumentException("Tasks required.");
        }
        String guid = UUID.randomUUID().toString();
        for (Task t : job.getTasks()) {
            t.setProperty("uuid", guid);
            if (t.getName() != null) continue;
            throw new OdpsException("Task name required.");
        }
        OdpsHooks hooks = null;
        if (OdpsHooks.isEnabled()) {
            hooks = new OdpsHooks();
            hooks.before(job, this.odps);
        }
        AnonymousInstance i = new AnonymousInstance();
        i.job = job.model;
        String xml = null;
        try {
            xml = JAXBUtils.marshal(i, AnonymousInstance.class);
        }
        catch (JAXBException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String resource = ResourceBuilder.buildInstancesResource(project);
        Response resp = this.client.stringRequest(resource, "POST", null, headers, xml);
        String location = resp.getHeaders().get("Location");
        if (location == null || location.trim().length() == 0) {
            throw new OdpsException("Invalid response, Location header required.");
        }
        String instanceId = location.substring(location.lastIndexOf("/") + 1);
        HashMap<String, Instance.Result> results = new HashMap<String, Instance.Result>();
        Instance.TaskStatusModel model = new Instance.TaskStatusModel();
        model.name = instanceId;
        if (resp.getStatus() == 200 && resp.getBody() != null && resp.getBody().length > 0) {
            try {
                Instance.InstanceResultModel result = JAXBUtils.unmarshal(resp, Instance.InstanceResultModel.class);
                for (Instance.InstanceResultModel.TaskResult taskResult : result.taskResults) {
                    model.tasks.add(this.createInstanceTaskModel(taskResult));
                    results.put(taskResult.name, taskResult.result);
                }
            }
            catch (JAXBException e) {
                throw new OdpsException("Invalid create instance response.", e);
            }
        }
        Instance instance = new Instance(project, model, results, this.odps);
        instance.setOdpsHooks(hooks);
        if (OdpsHooks.isEnabled()) {
            if (hooks == null) {
                hooks = new OdpsHooks();
            }
            hooks.onInstanceCreated(instance, this.odps);
        }
        return instance;
    }

    private Instance.TaskStatusModel.InstanceTaskModel createInstanceTaskModel(Instance.InstanceResultModel.TaskResult taskResult) {
        Instance.TaskStatusModel.InstanceTaskModel taskModel = new Instance.TaskStatusModel.InstanceTaskModel();
        taskModel.name = taskResult.name;
        taskModel.status = taskResult.status;
        taskModel.type = taskResult.type;
        return taskModel;
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    @Override
    public Iterator<Instance> iterator() {
        return this.iterator(this.getDefaultProjectName());
    }

    public Iterator<Instance> iterator(String project) {
        return this.iterator(project, null);
    }

    public Iterator<Instance> iterator(InstanceFilter filter) {
        return this.iterator(this.getDefaultProjectName(), filter);
    }

    public Iterator<Instance> iterator(String project, InstanceFilter filter) {
        return new InstanceListIterator(project, filter);
    }

    public Iterable<Instance> iterable() {
        return this.iterable(this.getDefaultProjectName());
    }

    public Iterable<Instance> iterable(String project) {
        return this.iterable(project, null);
    }

    public Iterable<Instance> iterable(InstanceFilter filter) {
        return this.iterable(this.getDefaultProjectName(), filter);
    }

    public Iterable<Instance> iterable(final String project, final InstanceFilter filter) {
        return new Iterable<Instance>(){

            @Override
            public Iterator<Instance> iterator() {
                return new InstanceListIterator(project, filter);
            }
        };
    }

    public Iterator<Instance.InstanceQueueingInfo> iteratorQueueing() {
        return this.iteratorQueueing(this.getDefaultProjectName());
    }

    public Iterator<Instance.InstanceQueueingInfo> iteratorQueueing(String project) {
        return this.iteratorQueueing(project, null);
    }

    public Iterator<Instance.InstanceQueueingInfo> iteratorQueueing(InstanceFilter filter) {
        return this.iteratorQueueing(this.getDefaultProjectName(), filter);
    }

    public Iterator<Instance.InstanceQueueingInfo> iteratorQueueing(String project, InstanceFilter filter) {
        return new InstanceQueueListIterator(project, filter);
    }

    private class InstanceQueueListIterator
    extends ListIterator<Instance.InstanceQueueingInfo> {
        Map<String, String> params = new HashMap<String, String>();
        InstanceFilter filter;
        String project;

        InstanceQueueListIterator(String projectName, InstanceFilter filter) {
            this.filter = filter;
            this.project = projectName;
        }

        @Override
        protected List<Instance.InstanceQueueingInfo> list() {
            if (this.params.containsKey("marker") && this.params.get("marker").length() == 0) {
                return null;
            }
            if (this.filter != null) {
                if (this.filter.getStatus() != null) {
                    this.params.put("status", this.filter.getStatus().toString());
                }
                if (this.filter.getOnlyOwner() != null) {
                    this.params.put("onlyowner", this.filter.getOnlyOwner() != false ? "yes" : "no");
                }
                if (this.filter.getQuotaIndex() != null) {
                    this.params.put("quotaindex", this.filter.getQuotaIndex());
                }
            }
            String resource = ResourceBuilder.buildCachedInstancesResource(this.project);
            try {
                ListInstanceQueueResponse resp = Instances.this.client.request(ListInstanceQueueResponse.class, resource, "GET", this.params);
                this.params.put("marker", resp.marker);
                ArrayList<Instance.InstanceQueueingInfo> result = new ArrayList<Instance.InstanceQueueingInfo>();
                if (resp.queue != null) {
                    for (JSONObject item : JSON.parseArray((String)resp.queue, JSONObject.class)) {
                        result.add(new Instance.InstanceQueueingInfo(item));
                    }
                }
                return result;
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private class InstanceListIterator
    extends ListIterator<Instance> {
        Map<String, String> params = new HashMap<String, String>();
        InstanceFilter filter;
        String project;

        InstanceListIterator(String projectName, InstanceFilter filter) {
            this.filter = filter;
            this.project = projectName;
        }

        @Override
        protected List<Instance> list() {
            ArrayList<Instance> instances = new ArrayList<Instance>();
            String lastMarker = this.params.get("marker");
            if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                return null;
            }
            if (this.filter != null) {
                if (this.filter.getStatus() != null) {
                    this.params.put("status", this.filter.getStatus().toString());
                }
                StringBuilder range = new StringBuilder();
                Date from = this.filter.getFromTime();
                Date end = this.filter.getEndTime();
                if (from != null && end != null && from.getTime() / 1000L >= end.getTime() / 1000L) {
                    throw new IllegalArgumentException("invalid query range, end value must be greater than begin value and they could not be in the same second!");
                }
                if (from != null) {
                    range.append(from.getTime() / 1000L);
                }
                if (from != null || end != null) {
                    range.append(':');
                }
                if (end != null) {
                    range.append(end.getTime() / 1000L);
                }
                if (range.length() > 0) {
                    this.params.put("daterange", range.toString());
                }
                if (this.filter.getOnlyOwner() != null) {
                    this.params.put("onlyowner", this.filter.getOnlyOwner() != false ? "yes" : "no");
                }
            }
            String resource = ResourceBuilder.buildInstancesResource(this.project);
            try {
                ListInstanceResponse resp = Instances.this.client.request(ListInstanceResponse.class, resource, "GET", this.params);
                for (Instance.TaskStatusModel model : resp.instances) {
                    Instance t = new Instance(this.project, model, null, Instances.this.odps);
                    instances.add(t);
                }
                this.params.put("marker", resp.marker);
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return instances;
        }
    }

    @XmlRootElement(name="Instance")
    private static class AnonymousInstance {
        @XmlElement(name="Job")
        Job.JobModel job;

        private AnonymousInstance() {
        }
    }

    @XmlRootElement(name="Instances")
    private static class ListInstanceQueueResponse {
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;
        @XmlElement(name="Content")
        private String queue;

        private ListInstanceQueueResponse() {
        }
    }

    @XmlRootElement(name="Instances")
    private static class ListInstanceResponse {
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;
        @XmlElement(name="Instance")
        private List<Instance.TaskStatusModel> instances = new ArrayList<Instance.TaskStatusModel>();

        private ListInstanceResponse() {
        }
    }
}

