/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.io;

import com.aliyun.odps.data.IntervalYearMonth;
import com.aliyun.odps.io.WritableComparable;
import com.aliyun.odps.io.WritableComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntervalYearMonthWritable
implements WritableComparable<IntervalYearMonthWritable> {
    private static final int MONTHS_PER_YEAR = 12;
    private int totalMonths;

    public IntervalYearMonthWritable() {
    }

    public IntervalYearMonthWritable(IntervalYearMonth value) {
        this(value.getTotalMonths());
    }

    public IntervalYearMonthWritable(int totalMonths) {
        this.set(totalMonths);
    }

    public IntervalYearMonth get() {
        return new IntervalYearMonth(this.totalMonths);
    }

    public void set(int totalMonths) {
        this.totalMonths = totalMonths;
    }

    public int getTotalMonths() {
        return this.totalMonths;
    }

    public void set(IntervalYearMonth interval) {
        this.set(interval.getTotalMonths());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.write(this.totalMonths);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.totalMonths = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalYearMonthWritable that = (IntervalYearMonthWritable)o;
        return this.totalMonths == that.totalMonths;
    }

    public int hashCode() {
        return this.totalMonths;
    }

    @Override
    public int compareTo(IntervalYearMonthWritable o) {
        return this.totalMonths < o.totalMonths ? -2 : (this.totalMonths == o.totalMonths ? 0 : 2);
    }

    static {
        WritableComparator.define(IntervalYearMonthWritable.class, new Comparator());
    }

    public static class DecreasingComparator
    extends Comparator {
        @Override
        public int compare(WritableComparable a, WritableComparable b) {
            return -super.compare(a, b);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return -super.compare(b1, s1, l1, b2, s2, l2);
        }
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(IntervalYearMonthWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            long thatValue;
            long thisValue = Comparator.readLong(b1, s1);
            return thisValue < (thatValue = Comparator.readLong(b2, s2)) ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

