/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.io;

import com.aliyun.odps.conf.Configurable;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.io.BooleanWritable;
import com.aliyun.odps.io.BytesWritable;
import com.aliyun.odps.io.DataInputBuffer;
import com.aliyun.odps.io.DataOutputBuffer;
import com.aliyun.odps.io.DatetimeWritable;
import com.aliyun.odps.io.DoubleWritable;
import com.aliyun.odps.io.IntWritable;
import com.aliyun.odps.io.LongWritable;
import com.aliyun.odps.io.MapWritable;
import com.aliyun.odps.io.NullWritable;
import com.aliyun.odps.io.SortedMapWritable;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.Tuple;
import com.aliyun.odps.io.Writable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractMapWritable
implements Writable,
Configurable {
    private AtomicReference<Configuration> conf;
    Map<Class, Byte> classToIdMap = new ConcurrentHashMap<Class, Byte>();
    Map<Byte, Class> idToClassMap = new ConcurrentHashMap<Byte, Class>();
    private volatile byte newClasses = 0;

    byte getNewClasses() {
        return this.newClasses;
    }

    private synchronized void addToMap(Class clazz, byte id) {
        Class c;
        byte b;
        if (this.classToIdMap.containsKey(clazz) && (b = this.classToIdMap.get(clazz).byteValue()) != id) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " already registered but maps to " + b + " and not " + id);
        }
        if (this.idToClassMap.containsKey(id) && !(c = this.idToClassMap.get(id)).equals(clazz)) {
            throw new IllegalArgumentException("Id " + id + " exists but maps to " + c.getName() + " and not " + clazz.getName());
        }
        this.classToIdMap.put(clazz, id);
        this.idToClassMap.put(id, clazz);
    }

    protected synchronized void addToMap(Class clazz) {
        if (this.classToIdMap.containsKey(clazz)) {
            return;
        }
        if (this.newClasses + 1 > 127) {
            throw new IndexOutOfBoundsException("adding an additional class would exceed the maximum number allowed");
        }
        byte id = this.newClasses = (byte)(this.newClasses + 1);
        this.addToMap(clazz, id);
    }

    protected Class getClass(byte id) {
        return this.idToClassMap.get(id);
    }

    protected byte getId(Class clazz) {
        return this.classToIdMap.containsKey(clazz) ? this.classToIdMap.get(clazz) : (byte)-1;
    }

    protected synchronized void copy(Writable other) {
        if (other != null) {
            try {
                DataOutputBuffer out = new DataOutputBuffer();
                other.write(out);
                DataInputBuffer in = new DataInputBuffer();
                in.reset(out.getData(), out.getLength());
                this.readFields(in);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("map cannot be copied: " + e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("source map cannot be null");
        }
    }

    protected AbstractMapWritable() {
        this.conf = new AtomicReference();
        this.addToMap(BooleanWritable.class, Integer.valueOf(-126).byteValue());
        this.addToMap(BytesWritable.class, Integer.valueOf(-125).byteValue());
        this.addToMap(DatetimeWritable.class, Integer.valueOf(-124).byteValue());
        this.addToMap(DoubleWritable.class, Integer.valueOf(-123).byteValue());
        this.addToMap(IntWritable.class, Integer.valueOf(-122).byteValue());
        this.addToMap(LongWritable.class, Integer.valueOf(-121).byteValue());
        this.addToMap(MapWritable.class, Integer.valueOf(-120).byteValue());
        this.addToMap(NullWritable.class, Integer.valueOf(-119).byteValue());
        this.addToMap(SortedMapWritable.class, Integer.valueOf(-118).byteValue());
        this.addToMap(Text.class, Integer.valueOf(-117).byteValue());
        this.addToMap(Tuple.class, Integer.valueOf(-116).byteValue());
    }

    @Override
    public Configuration getConf() {
        return this.conf.get();
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf.set(conf);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(this.newClasses);
        for (byte i = 1; i <= this.newClasses; i = (byte)(i + 1)) {
            out.writeByte(i);
            out.writeUTF(this.getClass(i).getName());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.newClasses = in.readByte();
        for (int i = 0; i < this.newClasses; ++i) {
            byte id = in.readByte();
            String className = in.readUTF();
            try {
                this.addToMap(Class.forName(className), id);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("can't find class: " + className + " because " + e.getMessage());
            }
        }
    }
}

