/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.tsdb.client;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.avatica.BuiltInConnectionProperty;
import org.apache.calcite.avatica.DriverVersion;
import org.apache.calcite.avatica.remote.HADriver;

public class Driver
extends HADriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:lindorm:tsdb:";
    public static final String JDBC_PROTOCOL_TERMINATOR = ";";
    public static final String PROPERTY_SEPARATOR = "=";
    private static final String DEFAULT_SERIALIZATION = "PROTOBUF";
    private static final String DEFAULT_ENDPOINT = "/api/v2/avatica";

    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, (String)"com-aliyun-lindorm-tsdb-jdbc.properties", (String)"Lindorm TSDB JDBC Driver", (String)"unknown version", (String)"Lindorm TSDB", (String)"unknown version");
    }

    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (!info.containsKey("user") || !info.containsKey("password")) {
            throw new SQLException("user and password can't be null");
        }
        String prefix = this.getConnectStringPrefix();
        String urlSuffix = url.substring(prefix.length());
        info.putAll((Map<?, ?>)this.readExtraConfigFromUrl(urlSuffix));
        String urlString = info.getProperty(BuiltInConnectionProperty.URL.camelName());
        if (urlString != null) {
            info.put(BuiltInConnectionProperty.URL.camelName(), urlString + DEFAULT_ENDPOINT);
        }
        info.put(BuiltInConnectionProperty.SERIALIZATION.camelName(), DEFAULT_SERIALIZATION);
        this.setConnectionInfo(info);
        Connection conn = super.connect(CONNECT_STRING_PREFIX, info);
        String schemaName = info.getProperty(BuiltInConnectionProperty.SCHEMA.camelName());
        if (schemaName != null) {
            conn.setSchema(schemaName);
        }
        return conn;
    }

    private Properties readExtraConfigFromUrl(String url) {
        String[] kvs;
        Properties info = new Properties();
        for (String kv : kvs = url.split(JDBC_PROTOCOL_TERMINATOR)) {
            String[] fields = kv.split(PROPERTY_SEPARATOR);
            if (fields.length != 2) continue;
            info.put(fields[0].trim(), fields[1].trim());
        }
        return info;
    }

    static {
        new Driver().register();
    }
}

