/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.util.Collections;
import java.util.Properties;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.ConnectionConfig;
import org.apache.calcite.avatica.remote.AvaticaHttpClient;
import org.apache.calcite.avatica.remote.Driver;
import org.apache.calcite.avatica.remote.FailoverRetryPolicy;
import org.apache.calcite.avatica.remote.HARemoteProtobufService;
import org.apache.calcite.avatica.remote.MockJsonService;
import org.apache.calcite.avatica.remote.ProtobufTranslation;
import org.apache.calcite.avatica.remote.ProtobufTranslationImpl;
import org.apache.calcite.avatica.remote.RemoteProtobufService;
import org.apache.calcite.avatica.remote.RemoteService;
import org.apache.calcite.avatica.remote.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HADriver
extends Driver {
    private static final Logger LOG = LoggerFactory.getLogger(HADriver.class);
    private Properties connectionInfo = new Properties();
    private static final String FAILOVER_NAME = "failover";
    private static final String DEFULT_FAILOVER_VALUE = "true";
    private static final String MAX_RETRIES_NAME = "maxRetries";
    private static final String INTERVAL_MILLIS_NAME = "interval";
    private static final String MAX_DELAY_NAME = "maxDelay";
    private static final Integer DEFAULT_MAX_RETRIES = 6;
    private static final Integer DEFAULT_MAX_DELAY_BASE = 15000;
    private static final Integer DEFAULT_INTERVAL_MILLIS = 500;
    public static final String LINDORM_TSDB_DRIVER_CONNECT_TIMEOUT = "lindorm.tsdb.driver.connect.timeout";
    public static final String DEFAULT_LINDORM_TSDB_DRIVER_CONNECT_TIMEOUT = "60000";
    public static final String LINDORM_TSDB_DRIVER_CONNECTION_REQUEST_TIMEOUT = "lindorm.tsdb.driver.connection.request.timeout";
    public static final String DEFAULT_LINDORM_TSDB_DRIVER_CONNECTION_REQUEST_TIMEOUT = "60000";
    public static final String LINDORM_TSDB_DRIVER_SOCKET_TIMEOUT = "lindorm.tsdb.driver.socket.timeout";
    public static final String DEFAULT_LINDORM_TSDB_DRIVER_SOCKET_TIMEOUT = "-1";
    public static final String LINDORM_TSDB_DRIVER_HTTP_COMPRESSION = "lindorm.tsdb.driver.http.compression";
    public static final String DEFAULT_LINDORM_TSDB_DRIVER_HTTP_COMPRESSION = "false";

    Service createService(AvaticaConnection connection, ConnectionConfig config) {
        Object service;
        Service.Factory metaFactory = config.factory();
        if (metaFactory != null) {
            service = metaFactory.create(connection);
        } else if (config.url() != null) {
            AvaticaHttpClient httpClient = this.getHttpClient(connection, config);
            Driver.Serialization serializationType = this.getSerialization(config);
            boolean failover = Boolean.valueOf(this.connectionInfo.getProperty(FAILOVER_NAME, DEFULT_FAILOVER_VALUE));
            LOG.debug("Instantiating {} service", (Object)serializationType);
            switch (serializationType) {
                case JSON: {
                    service = new RemoteService(httpClient);
                    break;
                }
                case PROTOBUF: {
                    if (failover) {
                        int maxRetries = Integer.valueOf(this.connectionInfo.getProperty(MAX_RETRIES_NAME, DEFAULT_MAX_RETRIES.toString()));
                        int intervalMills = Integer.valueOf(this.connectionInfo.getProperty(INTERVAL_MILLIS_NAME, DEFAULT_INTERVAL_MILLIS.toString()));
                        int maxDelay = Integer.valueOf(this.connectionInfo.getProperty(MAX_DELAY_NAME, DEFAULT_MAX_DELAY_BASE.toString()));
                        FailoverRetryPolicy retryPolicy = new FailoverRetryPolicy(maxRetries, intervalMills, maxDelay);
                        service = new HARemoteProtobufService(this.connectionInfo, httpClient, (ProtobufTranslation)new ProtobufTranslationImpl(), retryPolicy);
                        break;
                    }
                    service = new RemoteProtobufService(httpClient, (ProtobufTranslation)new ProtobufTranslationImpl());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled serialization type: " + serializationType);
                }
            }
        } else {
            service = new MockJsonService(Collections.emptyMap());
        }
        return service;
    }

    public void setConnectionInfo(Properties connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    static {
        new HADriver().register();
    }
}

