/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.clusterclient.impl;

import com.aliyun.drc.clusterclient.ClusterListener;
import com.aliyun.drc.clusterclient.RegionContext;
import com.aliyun.drc.clusterclient.impl.ClientCluster;
import com.aliyun.drc.clusterclient.partition.PartitionPool;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;

public class DefaultClusterClientImpl {
    private final ClientCluster cluster = new ClientCluster();
    private final PartitionPool partitionPool;
    private String guid;
    private List<ClusterListener> listeners = new ArrayList<ClusterListener>();

    public DefaultClusterClientImpl(RegionContext regionContext) {
        this.partitionPool = new PartitionPool(regionContext, this.cluster);
    }

    public void ask(String guid) throws Exception {
        this.guid = guid;
        this.cluster.setGuid(guid);
        this.partitionPool.setGuid(guid);
    }

    public void start() throws Exception {
        if (this.listeners.isEmpty()) {
            throw new Exception("no listeners registered");
        }
        for (ClusterListener listener : this.listeners) {
            listener.start();
        }
        this.partitionPool.setIp(InetAddress.getLocalHost().getHostAddress().toString());
        this.partitionPool.setSeq(RandomStringUtils.randomAlphanumeric((int)16));
        this.partitionPool.init();
        this.partitionPool.start();
        this.cluster.setPartitions(this.partitionPool);
        this.cluster.setListeners(this.listeners);
    }

    public void waitForStop() throws InterruptedException {
    }

    public void stop() throws Exception {
        this.partitionPool.shutdown();
        this.cluster.shutdown();
        for (ClusterListener listener : this.listeners) {
            listener.shutdown();
        }
    }

    public void addConcurrentListener(ClusterListener listener) {
        this.listeners.add(listener);
    }

    public List<ClusterListener> getConcurrentListeners() {
        return this.listeners;
    }
}

