package com.aliyun.drc.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

public class ThreadMonitor extends Thread {

    private Map<Thread, AbnormalThreadHook> monitoredThreads;

    public ThreadMonitor() {
        monitoredThreads = new HashMap<Thread, AbnormalThreadHook>();
    }

    synchronized public void addMonitoredThread(Thread e, AbnormalThreadHook hook) {
        monitoredThreads.put(e, hook);
    }

    synchronized public void pollMonitoredThreads() {
        Iterator<Entry<Thread, AbnormalThreadHook>> it =
                monitoredThreads.entrySet().iterator();
        while (it.hasNext()) {
            Entry<Thread, AbnormalThreadHook> entry = it.next();
            if (entry.getKey().isAlive()) {
                entry.getValue().notifyThreadFailed(entry.getKey());
                it.remove();
            }
        }
    }

    @Override
    public void run() {
        pollMonitoredThreads();
    }
}