package com.aliyun.drc.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by jianjundeng on 12/11/15.
 */
@SuppressWarnings({"unchecked", "rawtypes"})
public class CheckpointLinkedList<E> {

    private final static int MAX_SIZE = 1024 * 8;

    private Entry<E> header = new Entry<E>(null);

    private ReentrantLock lock = new ReentrantLock();

    private Condition full = lock.newCondition();

    private Map<E, Entry> entryMap = new ConcurrentHashMap<E, Entry>();

    private volatile E min;

    public CheckpointLinkedList() {
        header.setNext(header);
        header.setPrev(header);
    }

    //add double link list
    public void putElementCheckpointQueue(E e) {
        try {
            lock.lock();
            if (entryMap.size() == MAX_SIZE) {
                full.await();
            }
            Entry entry = new Entry(e);
            header.getPrev().setNext(entry);
            entry.setPrev(header.getPrev());
            entry.setNext(header);
            header.setPrev(entry);
            entryMap.put(e, entry);
        } catch (Exception exception) {
        } finally {
            lock.unlock();
        }
    }

    //remove entry from double link list
    public void removeElementFromCheckpointQueue(E e) {
        try {
            lock.lock();
            Entry entry = entryMap.get(e);
            if(entry == null) {
                return;
            }
            if (entry.getPrev() == header) {
                min = e;
            }
            entry.getPrev().setNext(entry.getNext());
            entry.getNext().setPrev(entry.getPrev());
            entryMap.remove(e);
            full.signal();
        } finally {
            lock.unlock();
        }
    }

    public void pushHeartBeatElement(E e) {
        try {
            lock.lock();
            if (header.getNext().equals(header)) {
                min = e;
            }
        } finally {
            lock.unlock();
        }
    }

    public E getMin() {
        return min;
    }

    public void setMin(E min) {
        this.min = min;
    }

    public int size() {
        return entryMap.size();
    }

    public class Entry<E> {

        private E element;

        private Entry<E> next;

        private Entry<E> prev;

        public Entry(E element) {
            this.element = element;
            this.next = this.prev = null;
        }

        public Entry(E element, Entry<E> next, Entry<E> prev) {
            this.element = element;
            this.next = next;
            this.prev = prev;
        }

        public void setNext(Entry<E> next) {
            this.next = next;
        }

        public void setPrev(Entry<E> prev) {
            this.prev = prev;
        }

        public Entry<E> getNext() {
            return next;
        }

        public Entry<E> getPrev() {
            return prev;
        }
    }

}
