package com.aliyun.drc.regionmanager;

import com.aliyun.drc.clusterclient.RegionContext;
import com.aliyun.drc.pop.drcGuidRouteApiRequest;
import com.aliyun.drc.pop.drcGuidRouteApiResponse;
import com.aliyun.drc.util.CipherUtils;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.Charset;
import java.util.List;

/**
 * Created by jianjundeng on 6/24/15.
 */
public class RegionRouter {

    private static Logger logger = LoggerFactory.getLogger(RegionRouter.class);

    private static final int TOKEN_EXPIRE_SECOND = 60 * 10;

    private RegionContext context;

    public RegionRouter(RegionContext regionContext) {
        this.context = regionContext;
    }

    public RegionRouterInfo getRegionRouterInfo(String guid) throws Exception {
        IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou", context.getAccessKey(), context.getSecret());
        DefaultAcsClient client = new DefaultAcsClient(profile);
        drcGuidRouteApiRequest request = new drcGuidRouteApiRequest();
        request.setguid(guid);
        drcGuidRouteApiResponse response = client.getAcsResponse(request);
        if (response.getSuccess() == null || !response.getSuccess()) {
            logger.error("get guid info failed, server response: " + response.getdata());
            throw new Exception("get guid info failed");
        }
        String decryptResponse = CipherUtils.decrypt(response.getdata());
        List<NameValuePair> list = URLEncodedUtils.parse(decryptResponse, Charset.defaultCharset());
        if (list.size() != 6) {
            logger.error("decrypted list size from token, expect: 6, actual: " + list.size());
            return null;
        }
        long ts = Long.parseLong(list.get(0).getValue());
        if (ts < (System.currentTimeMillis() / 1000 - TOKEN_EXPIRE_SECOND)) {
            logger.error("timestamp expired, server ts:" + ts + ", current client ts:" + String.valueOf(System.currentTimeMillis() / 1000));
            return null;
        }
        RegionRouterInfo regionRouterInfo = new RegionRouterInfo();
        regionRouterInfo.setConsumerGroup(list.get(1).getValue());
        regionRouterInfo.setClusterUrl(list.get(2).getValue());
        regionRouterInfo.setUsername(list.get(3).getValue());
        regionRouterInfo.setPassword(list.get(4).getValue());
        regionRouterInfo.setDataType(list.get(5).getValue());
        regionRouterInfo.setUsePublicIp(context.isUsePublicIp());
        return regionRouterInfo;
    }
}
