package com.aliyun.drc.httpclient;

import java.io.IOException;

import org.apache.http.impl.client.BasicResponseHandler;

public class HttpResponse {

    private int code;
    private String body;

    public HttpResponse(org.apache.http.HttpResponse response) throws IllegalStateException, IOException {
        code = response.getStatusLine().getStatusCode();
        try {
            body = new BasicResponseHandler().handleResponse(response);
        } catch (Exception e) {
            body = e.getMessage();
        }
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public void setString(final String body) {
        this.body = body;
    }

    public final String getString() {
        return body;
    }

    @Override
    public String toString() {
        return code + " " + body;
    }
}