package com.aliyun.drc.httpclient;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public class HttpClient {

    private final static String DefaultEncoding = "UTF-8";

    private final static int DefaultConnectionTimeout = 60 * 1000;

    private final static int DefaultSocketTimeout = 60 * 1000;

    private final static int DefaultMaxPerRoute = 20;

    private final static RequestConfig requestConfig = RequestConfig.custom()
                                                                    .setConnectTimeout(DefaultConnectionTimeout)
                                                                    .setSocketTimeout(DefaultSocketTimeout)
                                                                    .setConnectionRequestTimeout(DefaultConnectionTimeout)
                                                                    .build();

    private final static org.apache.http.client.HttpClient client;

	/* static {
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
		client = new DefaultHttpClient(cm);
		client.getParams().setParameter(
			CoreConnectionPNames.CONNECTION_TIMEOUT, DefaultConnectionTimeout);
		client.getParams().setParameter(
			CoreConnectionPNames.SO_TIMEOUT, DefaultSocketTimeout);
	} */

    static {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(DefaultMaxPerRoute);
        manager.setDefaultMaxPerRoute(DefaultMaxPerRoute);
        client = HttpClients.custom().setConnectionManager(manager).build();
    }

    public HttpResponse get(final String path) throws IOException {
        HttpGet method = new HttpGet(path);
        method.setConfig(requestConfig);
        org.apache.http.HttpResponse response = client.execute(method);
        HttpResponse resp = new HttpResponse(response);
        method.releaseConnection();
        if (resp.getCode() != 200) {
            throw new IllegalStateException("Register to " + path + " failed: " + resp);
        }
        return resp;
    }

    public HttpResponse post(final String url, final Map<String, String> posts) throws IllegalStateException, IOException {
        List<NameValuePair> parameters = new ArrayList<NameValuePair>();
        for (Entry<String, String> pair : posts.entrySet()) {
            parameters.add(new BasicNameValuePair(pair.getKey(), pair.getValue()));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters, DefaultEncoding);
        HttpPost method = new HttpPost(url);
        method.setEntity(entity);
        method.setConfig(requestConfig);
        HttpResponse resp = new HttpResponse(client.execute(method));
        method.releaseConnection();
        if (resp.getCode() != 200) {
            throw new IllegalStateException("Register to " + url + " failed: " + resp);
        }
        return resp;
    }
}
