package com.aliyun.drc.clustermanager;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.aliyun.drc.httpclient.HttpClient;
import com.aliyun.drc.httpclient.HttpResponse;

public class Register {

    private ClusterManager clusterManager;

    private HttpClient client;

    public Register(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
        this.client = new HttpClient();
    }

    public CommittedInfo commit(final Map<String, String> props) throws IllegalStateException, IOException {
        HttpResponse response = client.post(clusterManager.getAddress() + CommittedInfo.CommitPath, props);
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readValue(response.getString(), CommittedInfo.class);
    }

    public RegisteredInfo registerClientAsIdle(final Map<String, String> props) throws Exception {
        return registerClient(RegisteredInfo.RegisterPath, props);
    }

    public RegisteredInfo registerClientAsActive(final Map<String, String> props) throws Exception {
        return registerClient(ClientHeartbeat.HeartbeatPath, props);
    }

    private RegisteredInfo registerClient(final String path, final Map<String, String> props) throws Exception {
        HttpResponse response = client.post(clusterManager.getAddress() + path, props);
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readValue(response.getString(), RegisteredInfo.class);
    }
}