package com.aliyun.drc.clusterclient.partition;

import com.aliyun.drc.client.message.DataMessage.Record;
import org.apache.commons.lang3.StringUtils;

public class Checkpoint {

    private final static int IP = 0;

    private final static int PORT = 1;

    private final static int FILE = 2;

    private final static int OFF = 3;

    private final static int TMSP = 4;

    private final static int ID = 5;

    private String[] list;

    public Checkpoint(final String checkpoint) {
        list = new String[6];
        setCheckpoint(checkpoint);
    }

    public Checkpoint(final Record record) {
        list = new String[6];
        setCheckpoint(record);
    }

    public void setCheckpoint(final String checkpoint) {
        String[] splitted = checkpoint.split(":");
        for (int i = 0; i < splitted.length; i++) {
            if (splitted[i] != null && !splitted[i].isEmpty()) {
                list[i] = splitted[i];
            }
        }
    }

    public final String getIp() {
        return list[IP];
    }

    public final String getPort() {
        return list[PORT];
    }

    public final String getInstance() {
        if (list[IP] != null && list[PORT] != null) {
            return list[IP] + "-" + list[PORT];
        }
        return null;
    }

    public void setInstance(final String instance) {
        String[] ins = StringUtils.split(instance, '-');
        list[IP] = ins[0];
        list[PORT] = ins[1];
    }

    public final String getFile() {
        return list[FILE];
    }

    public final String getFileOffset() {
        return list[OFF];
    }

    public final String getFilePosition() {
        if (list[OFF] != null && list[FILE] != null) {
            return list[OFF] + "@" + list[FILE];
        }
        return null;
    }

    public void setFilePosition(final String pos) {
        if (pos == null) {
            return;
        }
        String[] filePosition = StringUtils.split(pos, '@');
        list[FILE] = filePosition[1];
        list[OFF] = filePosition[0];
    }

    public final String getTimestamp() {
        return list[TMSP];
    }

    public void setTimestamp(final String timestamp) {
        list[TMSP] = timestamp;
    }

    public final String getId() {
        return list[ID];
    }

    public void setId(final String id) {
        list[ID] = id;
    }

    public void setCheckpoint(final Record record) {
        if (record.getServerId() == null) {
            //for ob(127.0.0.1-1)
            setInstance("16843009-1");
        } else {
            setInstance(record.getServerId());
        }
        setFilePosition(record.getCheckpoint());
        setTimestamp(record.getTimestamp());
        setId(record.getId());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.length; i++) {
            builder.append(list[i]);
            if (i != list.length - 1) {
                builder.append(':');
            }
        }
        return builder.toString();
    }
}