package com.aliyun.drc.clusterclient.impl;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

import com.aliyun.drc.clusterclient.ClusterListener;
import com.aliyun.drc.clusterclient.RegionContext;
import com.aliyun.drc.clusterclient.partition.PartitionPool;
import org.apache.commons.lang3.RandomStringUtils;

public class DefaultClusterClientImpl {

    private final ClientCluster cluster;

    private final PartitionPool partitionPool;

    private String guid;

    private List<ClusterListener> listeners;

    public DefaultClusterClientImpl(RegionContext regionContext) {
        cluster = new ClientCluster();
        listeners = new ArrayList<ClusterListener>();
        partitionPool = new PartitionPool(regionContext, cluster);
    }

    public void ask(String guid) throws Exception {
        this.guid = guid;
        this.cluster.setGuid(guid);
        this.partitionPool.setGuid(guid);
    }

    public void start() throws Exception {
        if (listeners.isEmpty()) {
            throw new Exception("no listeners registered");
        }
        for(ClusterListener listener : listeners) {
            listener.start();
        }
        partitionPool.setIp(InetAddress.getLocalHost().getHostAddress().toString());
        partitionPool.setSeq(RandomStringUtils.randomAlphanumeric(16));
        partitionPool.init();
        partitionPool.start();
        cluster.setPartitions(partitionPool);
        cluster.setListeners(listeners);
    }

    public void waitForStop() throws InterruptedException {
    }

    public void stop() throws Exception {
        partitionPool.shutdown();
        cluster.shutdown();
        for(ClusterListener listener : listeners) {
            listener.shutdown();
        }
    }

    public void addConcurrentListener(ClusterListener listener) {
        listeners.add(listener);
    }

    public List<ClusterListener> getConcurrentListeners() {
        return listeners;
    }

//    public void resume() {
//        cluster.resumeClient();
//    }

//    public void suspend() {
//        cluster.suspendClient();
//    }
}