package com.aliyun.drc.clusterclient;

import java.util.List;

import com.aliyun.drc.clusterclient.impl.DefaultClusterClientImpl;

public class DefaultClusterClient implements ClusterClient {

    private DefaultClusterClientImpl defaultClusterClientImpl;

    public DefaultClusterClient(RegionContext regionContext) {
        defaultClusterClientImpl = new DefaultClusterClientImpl(regionContext);
    }

    public void askFor(String target) throws Exception {
        throw new Exception("ask for any target not supported yet");
    }

    public void askForGUID(String guid) throws Exception {
        defaultClusterClientImpl.ask(guid);
    }

    public void start() throws Exception {
        defaultClusterClientImpl.start();
    }

    public void waitForStop(long timeLimitInSec) throws InterruptedException {
        defaultClusterClientImpl.waitForStop();
    }

    public void stop() throws Exception {
        defaultClusterClientImpl.stop();
    }

    public void addConcurrentListener(ClusterListener listener) {
        defaultClusterClientImpl.addConcurrentListener(listener);
    }

    public List<ClusterListener> getConcurrentListeners() {
        return defaultClusterClientImpl.getConcurrentListeners();
    }

//    @Override
//    public void suspend() {
//        defaultClusterClientImpl.suspend();
//    }

//    @Override
//    public void resume() {
//        defaultClusterClientImpl.resume();
//    }

    public void addConcurrentListener(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        addConcurrentListener((ClusterListener) Class.forName(className).newInstance());
    }
}
