package com.aliyun.drc.clusterclient;

import java.io.IOException;
import java.util.List;

public interface ClusterClient {
    /**
     * Ask for subscribe target
     *
     * @param target target
     * @throws Exception Exception
     */
    public void askFor(final String target) throws Exception;

    /**
     * Ask for GUID
     *
     * @param guid guid
     * @throws Exception Exception
     */
    public void askForGUID(final String guid) throws Exception;

    /**
     * Start to launch client
     *
     * @throws Exception Exception
     */
    public void start() throws Exception;

    /**
     * Wait for limited time to stop, mainly for testing
     *
     * @param timelimitInSec limited time to wait for stopped
     * @throws InterruptedException InterruptedException
     */
    public void waitForStop(long timelimitInSec) throws InterruptedException;

    /**
     * Stop to launch client
     *
     * @throws Exception Exception
     */
    public void stop() throws Exception;

    /**
     * Add concurrent listener, listener consumes partition one by one
     *
     * @param listener listener
     */
    public void addConcurrentListener(ClusterListener listener);

    /**
     * Add concurrent listener using default constructor by class name
     *
     * @param className className
     * @throws InstantiationException InstantiationException
     * @throws IllegalAccessException IllegalAccessException
     * @throws ClassNotFoundException ClassNotFoundException
     */
    public void addConcurrentListener(String className)
            throws InstantiationException, IllegalAccessException, ClassNotFoundException;

    /**
     * Get concurrent listener list
     *
     * @return List for listener
     */
    public List<ClusterListener> getConcurrentListeners();

    /**
     * suspend client
     */
    //public void suspend();

    /**
     * resume client
     */
    //public void resume();

}
