/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.Row;
import com.aliyun.openservices.tablestore.hadoop.Credential;
import com.aliyun.openservices.tablestore.hadoop.Endpoint;
import com.aliyun.openservices.tablestore.hadoop.PrimaryKeyWritable;
import com.aliyun.openservices.tablestore.hadoop.RowWritable;
import com.aliyun.openservices.tablestore.hadoop.TableStoreInputSplit;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStoreRecordReader
extends RecordReader<PrimaryKeyWritable, RowWritable> {
    private static final Logger logger = LoggerFactory.getLogger(TableStoreRecordReader.class);
    private SyncClient ots;
    private RangeRowQueryCriteria scan;
    private PrimaryKey currentKey;
    private Row currentValue;
    private Iterator<Row> results;
    private long rowCounter;

    public void close() {
        if (this.ots != null) {
            this.ots.shutdown();
            this.ots = null;
        }
        this.scan = null;
        this.currentKey = null;
        this.currentValue = null;
        this.results = null;
        this.rowCounter = 0L;
    }

    public PrimaryKeyWritable getCurrentKey() {
        return new PrimaryKeyWritable(this.currentKey);
    }

    public RowWritable getCurrentValue() {
        return new RowWritable(this.currentValue);
    }

    public float getProgress() {
        return 0.0f;
    }

    public boolean nextKeyValue() {
        if (!this.results.hasNext()) {
            logger.info("total rows: {}", (Object)this.rowCounter);
            return false;
        }
        this.currentValue = this.results.next();
        this.currentKey = this.currentValue.getPrimaryKey();
        ++this.rowCounter;
        if (this.rowCounter % 1000L == 0L) {
            logger.info("deal with rows: {}", (Object)this.rowCounter);
        }
        return true;
    }

    public void initialize(InputSplit split, TaskAttemptContext ctx) {
        this.initialize(split, ctx.getConfiguration());
    }

    public void initialize(InputSplit split, Configuration cfg) {
        this.close();
        String in = cfg.get("TABLESTORE_CREDENTIAL");
        Preconditions.checkNotNull((Object)in, (Object)"Must set \"TABLESTORE_CREDENTIAL\"");
        Credential cred = Credential.deserialize(in);
        String in2 = cfg.get("TABLESTORE_ENDPOINT");
        Preconditions.checkNotNull((Object)in2, (Object)"Must set \"TABLESTORE_ENDPOINT\"");
        Endpoint ep = Endpoint.deserialize(in2);
        this.ots = cred.securityToken == null ? new SyncClient(ep.endpoint, cred.accessKeyId, cred.accessKeySecret, ep.instance) : new SyncClient(ep.endpoint, cred.accessKeyId, cred.accessKeySecret, ep.instance, cred.securityToken);
        TableStoreInputSplit tsSplit = (TableStoreInputSplit)split;
        this.scan = tsSplit.getRangeRowQueryCriteria();
        logger.info("table: {} columns-to-get: {} start: {} end: {}", new Object[]{this.scan.getTableName(), this.scan.getColumnsToGet(), this.scan.getInclusiveStartPrimaryKey().toString(), this.scan.getExclusiveEndPrimaryKey().toString()});
        this.results = this.ots.createRangeIterator(new RangeIteratorParameter(this.scan));
    }
}

