/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.aliyun.openservices.tablestore.hadoop.BatchWriteWritable;
import com.aliyun.openservices.tablestore.hadoop.Credential;
import com.aliyun.openservices.tablestore.hadoop.Endpoint;
import com.aliyun.openservices.tablestore.hadoop.TableStore;
import com.aliyun.openservices.tablestore.hadoop.TableStoreRecordWriter;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStoreOutputFormat
extends OutputFormat<Writable, BatchWriteWritable> {
    public static final String OUTPUT_TABLE = "TABLESTORE_OUTPUT_TABLE";
    public static final String MAX_UPDATE_BATCH_SIZE = "TABLESTORE_MAX_UPDATE_BATCH_SIZE";
    private static final Logger logger = LoggerFactory.getLogger(TableStoreOutputFormat.class);

    public static void setCredential(JobContext job, String accessKeyId, String accessKeySecret) {
        TableStore.setCredential(job, accessKeyId, accessKeySecret);
    }

    public static void setCredential(JobContext job, String accessKeyId, String accessKeySecret, String securityToken) {
        TableStore.setCredential(job, accessKeyId, accessKeySecret, securityToken);
    }

    public static void setCredential(Configuration conf, Credential cred) {
        TableStore.setCredential(conf, cred);
    }

    public static void setEndpoint(JobContext job, String endpoint) {
        TableStore.setEndpoint(job, endpoint);
    }

    public static void setEndpoint(JobContext job, String endpoint, String instance) {
        TableStore.setEndpoint(job, endpoint, instance);
    }

    public static void setEndpoint(Configuration conf, Endpoint ep) {
        TableStore.setEndpoint(conf, ep);
    }

    public static void setOutputTable(JobContext job, String outputTable) {
        TableStoreOutputFormat.setOutputTable(job.getConfiguration(), outputTable);
    }

    public static void setOutputTable(Configuration conf, String outputTable) {
        Preconditions.checkNotNull((Object)outputTable, (Object)"Output table must be nonnull.");
        conf.set(OUTPUT_TABLE, outputTable);
    }

    public static void setMaxBatchSize(JobContext job, int maxBatchSize) {
        TableStoreOutputFormat.setMaxBatchSize(job.getConfiguration(), maxBatchSize);
    }

    public static void setMaxBatchSize(Configuration conf, int maxBatchSize) {
        Preconditions.checkArgument((maxBatchSize > 0 ? 1 : 0) != 0, (Object)"maxBatchsize must be greater than 0.");
        conf.setInt(MAX_UPDATE_BATCH_SIZE, maxBatchSize);
    }

    public void checkOutputSpecs(JobContext job) throws IOException, InterruptedException {
        Configuration conf = job.getConfiguration();
        TableStoreOutputFormat.checkTable(conf);
    }

    public static void checkTable(Configuration conf) throws IOException {
        String outputTable = conf.get(OUTPUT_TABLE);
        Preconditions.checkNotNull((Object)outputTable, (Object)"Output table must be nonnull.");
        SyncClientInterface ots = TableStore.newOtsClient(conf);
        try {
            ots.describeTable(new DescribeTableRequest(outputTable));
            logger.info("{} exists", (Object)outputTable);
        }
        catch (TableStoreException ex) {
            logger.error("{} does not exist, or it is unaccessible.", (Object)outputTable);
            logger.error("{}", (Throwable)ex);
            throw new IOException("output table is unaccessible.");
        }
        finally {
            ots.shutdown();
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new OutputCommitter(){

            public void abortJob(JobContext jobContext, JobStatus.State state) {
            }

            public void abortTask(TaskAttemptContext taskContext) {
            }

            public void commitJob(JobContext jobContext) {
            }

            public void commitTask(TaskAttemptContext taskContext) {
            }

            public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
                return false;
            }

            public void recoverTask(TaskAttemptContext taskContext) throws IOException {
            }

            public void setupJob(JobContext jobContext) throws IOException {
            }

            public void setupTask(TaskAttemptContext taskContext) throws IOException {
            }
        };
    }

    public RecordWriter<Writable, BatchWriteWritable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String outputTable = conf.get(OUTPUT_TABLE);
        Preconditions.checkNotNull((Object)outputTable, (Object)"Output table must be set.");
        SyncClientInterface ots = TableStore.newOtsClient(conf);
        int maxBatchSize = conf.getInt(MAX_UPDATE_BATCH_SIZE, 0);
        if (maxBatchSize == 0) {
            return new TableStoreRecordWriter(ots, outputTable);
        }
        return new TableStoreRecordWriter(ots, outputTable, maxBatchSize);
    }
}

