/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.aliyun.openservices.tablestore.hadoop.RangeRowQueryCriteriaWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class TableStoreInputSplit
extends InputSplit
implements Writable {
    private RangeRowQueryCriteria criteria = null;

    public TableStoreInputSplit() {
    }

    public TableStoreInputSplit(RangeRowQueryCriteria criteria) {
        Preconditions.checkNotNull((Object)criteria, (Object)"criteria should not be null.");
        this.criteria = criteria;
    }

    public RangeRowQueryCriteria getRangeRowQueryCriteria() {
        return this.criteria;
    }

    public long getLength() throws IOException, InterruptedException {
        return 0L;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return new String[0];
    }

    public void write(DataOutput out) throws IOException {
        Preconditions.checkNotNull((Object)this.criteria, (Object)"criteria should not be null.");
        new RangeRowQueryCriteriaWritable(this.criteria).write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.criteria = RangeRowQueryCriteriaWritable.read(in).getRangeRowQueryCriteria();
    }

    public static TableStoreInputSplit read(DataInput in) throws IOException {
        TableStoreInputSplit w = new TableStoreInputSplit();
        w.readFields(in);
        return w;
    }
}

